/*
 * Decompiled with CFR 0.152.
 */
package one.jpro.platform.auth.core.jwt;

import java.util.Optional;
import one.jpro.platform.auth.core.authentication.Options;
import one.jpro.platform.auth.core.jwt.JWTOptions;
import org.json.JSONObject;

public class JWTAuthOptions
implements Options {
    private static final JWTOptions JWT_OPTIONS = new JWTOptions();
    private String site;
    private JWTOptions jwtOptions;

    public JWTAuthOptions() {
        this.jwtOptions = JWT_OPTIONS;
    }

    public JWTAuthOptions(JWTAuthOptions other) {
        this.site = other.site;
        this.jwtOptions = other.jwtOptions;
    }

    public String getSite() {
        return this.site;
    }

    public JWTAuthOptions setSite(String site) {
        this.site = site;
        return this;
    }

    public JWTOptions getJWTOptions() {
        return this.jwtOptions;
    }

    public JWTAuthOptions setJWTOptions(JWTOptions jwtOptions) {
        this.jwtOptions = jwtOptions;
        return this;
    }

    @Override
    public JSONObject toJSON() {
        JSONObject json = new JSONObject();
        Optional.ofNullable(this.getSite()).ifPresent(site -> json.put("site", site));
        Optional.ofNullable(this.getJWTOptions()).ifPresent(jwtOptions -> json.put("jwt_options", (Object)jwtOptions.toJSON()));
        return json;
    }
}

