/*
 * Decompiled with CFR 0.152.
 */
package one.jpro.platform.auth.core.http.impl;

import java.util.List;
import one.jpro.platform.auth.core.http.impl.ByteMerger;
import one.jpro.platform.auth.core.http.impl.Header;

record Response(int status, String reason, List<Header> headers, byte[] body) {
    static final byte[] COLON_SPACE = ": ".getBytes();
    static final byte[] SPACE = " ".getBytes();
    static final byte[] CRLF = "\r\n".getBytes();

    public boolean hasHeader(String name) {
        for (Header header : this.headers) {
            if (!header.name().equalsIgnoreCase(name)) continue;
            return true;
        }
        return false;
    }

    byte[] serialize(String version, List<Header> headers) {
        ByteMerger merger = new ByteMerger();
        merger.add(version.getBytes());
        merger.add(SPACE);
        merger.add(Integer.toString(this.status).getBytes());
        merger.add(SPACE);
        merger.add(this.reason.getBytes());
        merger.add(CRLF);
        Response.appendHeaders(merger, headers);
        Response.appendHeaders(merger, this.headers);
        merger.add(CRLF);
        merger.add(this.body);
        return merger.merge();
    }

    private static void appendHeaders(ByteMerger merger, List<Header> headers) {
        for (Header header : headers) {
            merger.add(header.name().getBytes());
            merger.add(COLON_SPACE);
            merger.add(header.value().getBytes());
            merger.add(CRLF);
        }
    }
}

