/*
 * Decompiled with CFR 0.152.
 */
package one.jpro.platform.auth.core.oauth2;

public enum OAuth2Flow {
    AUTH_CODE("authorization_code"),
    PASSWORD("password"),
    CLIENT("client_credentials"),
    AUTH_JWT("urn:ietf:params:oauth:grant-type:jwt-bearer");

    private final String grantType;

    private OAuth2Flow(String grantType) {
        this.grantType = grantType;
    }

    public String getGrantType() {
        return this.grantType;
    }

    public static OAuth2Flow getFlow(String grantType) {
        for (OAuth2Flow flow : OAuth2Flow.values()) {
            if (!flow.getGrantType().equals(grantType)) continue;
            return flow;
        }
        return null;
    }

    public String toString() {
        return this.name() + " [" + this.grantType + "]";
    }
}

