/*
 * Decompiled with CFR 0.152.
 */
package one.jpro.platform.auth.core.basic;

import java.util.Objects;
import java.util.ResourceBundle;
import javafx.beans.value.ObservableValue;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.Label;
import javafx.scene.control.PasswordField;
import javafx.scene.control.TextField;
import javafx.scene.layout.VBox;
import one.jpro.platform.auth.core.basic.UsernamePasswordCredentials;
import org.jetbrains.annotations.NotNull;

public class LoginPane
extends VBox {
    private static final String DEFAULT_STYLE_CLASS = "login-pane";
    private final Label headerLabel;
    private final Label usernameLabel;
    private final TextField usernameField;
    private final Label passwordLabel;
    private final PasswordField passwordField;
    private final Button submitButton;

    public LoginPane(@NotNull UsernamePasswordCredentials credentials) {
        this(credentials, ResourceBundle.getBundle("one.jpro.platform.auth.core.basic.login-pane"));
    }

    public LoginPane(@NotNull UsernamePasswordCredentials credentials, @NotNull ResourceBundle langBundle) {
        Objects.requireNonNull(credentials, "Credentials cannot be null");
        Objects.requireNonNull(langBundle, "Language bundle cannot be null");
        this.getStyleClass().add((Object)DEFAULT_STYLE_CLASS);
        this.headerLabel = new Label(langBundle.getString("label.header"));
        this.headerLabel.getStyleClass().add((Object)"header-label");
        this.usernameLabel = new Label(langBundle.getString("label.username"));
        this.usernameLabel.getStyleClass().add((Object)"username-label");
        this.usernameField = new TextField();
        this.usernameField.getStyleClass().add((Object)"username-field");
        credentials.usernameProperty().bind((ObservableValue)this.usernameField.textProperty());
        this.passwordLabel = new Label(langBundle.getString("label.password"));
        this.passwordLabel.getStyleClass().add((Object)"password-label");
        this.passwordField = new PasswordField();
        this.passwordField.getStyleClass().add((Object)"password-field");
        credentials.passwordProperty().bind((ObservableValue)this.passwordField.textProperty());
        this.submitButton = new Button(langBundle.getString("button.submit"));
        this.submitButton.getStyleClass().add((Object)"submit-button");
        this.submitButton.setDefaultButton(true);
        this.getChildren().addAll((Object[])new Node[]{this.headerLabel, this.usernameLabel, this.usernameField, this.passwordLabel, this.passwordField, this.submitButton});
    }

    @NotNull
    public final Label getHeaderLabel() {
        return this.headerLabel;
    }

    @NotNull
    public final Label getUsernameLabel() {
        return this.usernameLabel;
    }

    @NotNull
    public final TextField getUsernameField() {
        return this.usernameField;
    }

    @NotNull
    public final Label getPasswordLabel() {
        return this.passwordLabel;
    }

    @NotNull
    public final PasswordField getPasswordField() {
        return this.passwordField;
    }

    @NotNull
    public final Button getSubmitButton() {
        return this.submitButton;
    }
}

