/*
 * Decompiled with CFR 0.152.
 */
package one.jpro.platform.auth.core.crypto.bcrypt;

import java.security.SecureRandom;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import one.jpro.platform.auth.core.crypto.PasswordEncoder;
import one.jpro.platform.auth.core.crypto.bcrypt.BCrypt;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BCryptPasswordEncoder
implements PasswordEncoder {
    private static final Logger logger = LoggerFactory.getLogger(BCryptPasswordEncoder.class);
    private final Pattern BCRYPT_PATTERN = Pattern.compile("\\A\\$2([ayb])?\\$(\\d\\d)\\$[./0-9A-Za-z]{53}");
    private final int strength;
    private final BCrypt.Version version;
    private final SecureRandom random;

    public BCryptPasswordEncoder() {
        this(-1);
    }

    public BCryptPasswordEncoder(int strength) {
        this(strength, null);
    }

    public BCryptPasswordEncoder(BCrypt.Version version) {
        this(version, null);
    }

    public BCryptPasswordEncoder(BCrypt.Version version, SecureRandom random) {
        this(version, -1, random);
    }

    public BCryptPasswordEncoder(int strength, SecureRandom random) {
        this(BCrypt.Version.$2A, strength, random);
    }

    public BCryptPasswordEncoder(BCrypt.Version version, int strength) {
        this(version, strength, null);
    }

    public BCryptPasswordEncoder(BCrypt.Version version, int strength, SecureRandom random) {
        if (strength != -1 && (strength < 4 || strength > 31)) {
            throw new IllegalArgumentException("Bad strength");
        }
        this.version = version;
        this.strength = strength == -1 ? 10 : strength;
        this.random = random;
    }

    @Override
    public String encode(CharSequence rawPassword) {
        if (rawPassword == null) {
            throw new IllegalArgumentException("rawPassword cannot be null");
        }
        String salt = this.getSalt();
        return BCrypt.hashpw(rawPassword.toString(), salt);
    }

    @Override
    public boolean matches(CharSequence rawPassword, String encodedPassword) {
        if (rawPassword == null) {
            throw new IllegalArgumentException("rawPassword cannot be null");
        }
        if (encodedPassword == null || encodedPassword.isEmpty()) {
            logger.warn("Empty encoded password");
            return false;
        }
        if (!this.BCRYPT_PATTERN.matcher(encodedPassword).matches()) {
            logger.warn("Encoded password does not look like BCrypt");
            return false;
        }
        return BCrypt.checkpw(rawPassword.toString(), encodedPassword);
    }

    @Override
    public boolean upgradeEncoding(String encodedPassword) {
        if (encodedPassword == null || encodedPassword.isEmpty()) {
            logger.warn("Empty encoded password");
            return false;
        }
        Matcher matcher = this.BCRYPT_PATTERN.matcher(encodedPassword);
        if (!matcher.matches()) {
            throw new IllegalArgumentException("Encoded password does not look like BCrypt: " + encodedPassword);
        }
        int strength = Integer.parseInt(matcher.group(2));
        return strength < this.strength;
    }

    private String getSalt() {
        if (this.random != null) {
            return BCrypt.gensalt(this.version.getValue(), this.strength, this.random);
        }
        return BCrypt.gensalt(this.version.getValue(), this.strength);
    }
}

