/*
 * Decompiled with CFR 0.152.
 */
package one.jpro.platform.auth.core.http.impl;

import com.jpro.webapi.WebAPI;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import one.jpro.platform.auth.core.http.HttpServer;
import org.jetbrains.annotations.NotNull;

public class JProServerImpl
implements HttpServer {
    @NotNull
    private final WebAPI webAPI;

    public JProServerImpl(@NotNull WebAPI webAPI) {
        this.webAPI = Objects.requireNonNull(webAPI, "WebAPI cannot be null");
    }

    @Override
    public void start() {
    }

    @Override
    public void stop() {
    }

    @Override
    public String getServerHost() {
        String serverName = this.webAPI.getServer();
        int idx = serverName.indexOf(58);
        return idx >= 0 ? serverName.substring(0, idx) : serverName;
    }

    @Override
    public int getServerPort() {
        String serverName = this.webAPI.getServer();
        int idx = serverName.indexOf(58);
        return idx >= 0 ? Integer.parseInt(serverName.substring(idx + 1)) : -1;
    }

    @Override
    public String getFullRequestedURL() {
        return this.webAPI.getBrowserURL();
    }

    @Override
    public CompletableFuture<String> openURL(@NotNull String url) {
        return CompletableFuture.runAsync(() -> this.webAPI.openURL(url)).thenCompose(v -> CompletableFuture.completedFuture(null));
    }
}

