/*
 * Decompiled with CFR 0.152.
 */
package one.jpro.platform.auth.core.oauth2;

import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.util.Optional;
import one.jpro.platform.auth.core.authentication.Options;
import org.json.JSONObject;

public class PubSecKeyOptions
implements Options {
    private String id;
    private String algorithm;
    private Buffer buffer;

    public PubSecKeyOptions() {
    }

    public PubSecKeyOptions(PubSecKeyOptions other) {
        this.id = other.id;
        this.algorithm = other.algorithm;
        this.buffer = other.buffer;
    }

    public String getId() {
        return this.id;
    }

    public PubSecKeyOptions setId(String id) {
        this.id = id;
        return this;
    }

    public String getAlgorithm() {
        return this.algorithm;
    }

    public PubSecKeyOptions setAlgorithm(String algorithm) {
        this.algorithm = algorithm;
        return this;
    }

    public Buffer getBuffer() {
        return this.buffer;
    }

    public PubSecKeyOptions setBuffer(String buffer) {
        this.buffer = ByteBuffer.wrap(buffer.getBytes(StandardCharsets.UTF_8));
        return this;
    }

    public PubSecKeyOptions setBuffer(Buffer buffer) {
        this.buffer = buffer;
        return this;
    }

    @Override
    public JSONObject toJSON() {
        JSONObject json = new JSONObject();
        Optional.ofNullable(this.getId()).ifPresent(id -> json.put("id", id));
        Optional.ofNullable(this.getAlgorithm()).ifPresent(algorithm -> json.put("algorithm", algorithm));
        Optional.ofNullable(this.getBuffer()).ifPresent(buffer -> json.put("buffer", buffer));
        return json;
    }
}

