/*
 * Decompiled with CFR 0.152.
 */
package one.jpro.platform.auth.core.oauth2.provider;

import java.util.concurrent.CompletableFuture;
import javafx.stage.Stage;
import one.jpro.platform.auth.core.oauth2.OAuth2Flow;
import one.jpro.platform.auth.core.oauth2.OAuth2Options;
import one.jpro.platform.auth.core.oauth2.PubSecKeyOptions;
import one.jpro.platform.auth.core.oauth2.provider.OpenIDAuthenticationProvider;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.json.JSONObject;

public class KeycloakAuthenticationProvider
extends OpenIDAuthenticationProvider {
    public KeycloakAuthenticationProvider(@Nullable Stage stage, @NotNull OAuth2Options options) {
        super(stage, options);
    }

    public KeycloakAuthenticationProvider(@Nullable Stage stage, @NotNull JSONObject config) {
        this(stage, OAuth2Flow.AUTH_CODE, config);
    }

    public KeycloakAuthenticationProvider(@Nullable Stage stage, @Nullable OAuth2Flow flow, @NotNull JSONObject config) {
        super(stage, KeycloakAuthenticationProvider.configure(flow, config));
    }

    private static OAuth2Options configure(@Nullable OAuth2Flow flow, @NotNull JSONObject config) {
        OAuth2Options options = new OAuth2Options();
        options.setFlow(flow);
        if (config.has("resource")) {
            options.setClientId(config.getString("resource"));
        }
        if (config.has("auth-server-url")) {
            options.setSite(config.getString("auth-server-url"));
        }
        if (config.has("credentials") && config.getJSONObject("credentials").has("secret")) {
            options.setClientSecret(config.getJSONObject("credentials").getString("secret"));
        }
        if (config.has("realm")) {
            String realm = config.getString("realm");
            options.setTenant(realm);
            options.setAuthorizationPath("/protocol/openid-connect/auth");
            options.setTokenPath("/protocol/openid-connect/token");
            options.setRevocationPath("/protocol/openid-connect/revoke");
            options.setUserInfoPath("/protocol/openid-connect/userinfo");
            options.setLogoutPath("/protocol/openid-connect/logout");
            options.setIntrospectionPath("/protocol/openid-connect/token/introspect");
            options.setJwkPath("/protocol/openid-connect/certs");
        }
        if (config.has("realm-public-key")) {
            options.addPubSecKeys(new PubSecKeyOptions().setAlgorithm("RS256").setBuffer("-----BEGIN PUBLIC KEY-----\n" + config.getString("realm-public-key") + "\n-----END PUBLIC KEY-----\n"));
        }
        return options;
    }

    public static CompletableFuture<OpenIDAuthenticationProvider> discover(@Nullable Stage stage, @NotNull OAuth2Options options) {
        return new KeycloakAuthenticationProvider(stage, options).discover();
    }
}

