/*
 * Decompiled with CFR 0.152.
 */
package one.jpro.platform.auth.core.oauth2.provider;

import java.util.List;
import java.util.concurrent.CompletableFuture;
import javafx.stage.Stage;
import one.jpro.platform.auth.core.jwt.JWTOptions;
import one.jpro.platform.auth.core.oauth2.OAuth2Flow;
import one.jpro.platform.auth.core.oauth2.OAuth2Options;
import one.jpro.platform.auth.core.oauth2.provider.OpenIDAuthenticationProvider;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MicrosoftAuthenticationProvider
extends OpenIDAuthenticationProvider {
    public static final String COMMON_TENANT = "common";
    public static final String CONSUMERS_TENANT = "consumers";
    public static final String ORGANIZATIONS_TENANT = "organizations";
    public static final List<String> DEFAULT_SCOPES = List.of("openid", "profile", "email", "offline_access");

    public MicrosoftAuthenticationProvider(@Nullable Stage stage, @NotNull OAuth2Options options) {
        super(stage, options);
    }

    public MicrosoftAuthenticationProvider(@Nullable Stage stage, @NotNull String clientId, @NotNull String clientSecret, @NotNull String tenant) {
        super(stage, new OAuth2Options().setFlow(OAuth2Flow.AUTH_CODE).setClientId(clientId).setClientSecret(clientSecret).setTenant(tenant).setSupportedScopes(DEFAULT_SCOPES).setSite("https://login.microsoftonline.com/{tenant}/v2.0").setTokenPath("https://login.microsoftonline.com/{tenant}/oauth2/v2.0/token").setAuthorizationPath("https://login.microsoftonline.com/{tenant}/oauth2/v2.0/authorize").setUserInfoPath("https://graph.microsoft.com/oidc/userinfo").setJwkPath("https://login.microsoftonline.com/{tenant}/discovery/v2.0/keys").setLogoutPath("https://login.microsoftonline.com/{tenant}/oauth2/v2.0/logout").setJWTOptions(new JWTOptions().setNonceAlgorithm("SHA-256")));
    }

    public static CompletableFuture<OpenIDAuthenticationProvider> discover(Stage stage, OAuth2Options options) {
        JWTOptions jwtOptions;
        String site = options.getSite() == null ? "https://login.microsoftonline.com/{tenant}/v2.0" : options.getSite();
        JWTOptions jWTOptions = jwtOptions = options.getJWTOptions() == null ? new JWTOptions() : new JWTOptions(options.getJWTOptions());
        if (jwtOptions.getNonceAlgorithm() == null) {
            jwtOptions.setNonceAlgorithm("SHA-256");
        }
        return new MicrosoftAuthenticationProvider(stage, new OAuth2Options(options).setValidateIssuer(false).setSite(site).setJWTOptions(jwtOptions)).discover();
    }
}

