/*
 * Decompiled with CFR 0.152.
 */
package one.jpro.platform.auth.core.oauth2;

import io.jsonwebtoken.Jwe;
import io.jsonwebtoken.Jwts;
import io.jsonwebtoken.io.Encoders;
import java.net.URI;
import java.net.http.HttpClient;
import java.net.http.HttpHeaders;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javafx.stage.Stage;
import one.jpro.platform.auth.core.authentication.AuthenticationException;
import one.jpro.platform.auth.core.http.HttpMethod;
import one.jpro.platform.auth.core.jwt.JWTOptions;
import one.jpro.platform.auth.core.oauth2.OAuth2Credentials;
import one.jpro.platform.auth.core.oauth2.OAuth2Flow;
import one.jpro.platform.auth.core.oauth2.OAuth2Options;
import one.jpro.platform.auth.core.oauth2.provider.OpenIDAuthenticationProvider;
import one.jpro.platform.auth.core.utils.AuthUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.json.JSONArray;
import org.json.JSONObject;

public class OAuth2API {
    private static final Pattern MAX_AGE = Pattern.compile("max-age=\"?(\\d+)\"?");
    private static final String CACHE_CONTROL = "cache-control";
    @NotNull
    protected final OAuth2Options options;
    @NotNull
    private final HttpClient httpClient;

    public OAuth2API(@NotNull OAuth2Options options) {
        this.options = Objects.requireNonNull(options, "OAuth2 options cannot be null");
        this.httpClient = HttpClient.newHttpClient();
    }

    @NotNull
    public OAuth2Options getOptions() {
        return this.options;
    }

    public String authorizeURL(@NotNull OAuth2Credentials credentials) {
        String clientId;
        String state;
        String redirectUri;
        JSONObject query = new JSONObject();
        OAuth2Flow flow = credentials.getFlow() != null ? credentials.getFlow() : this.options.getFlow();
        if (flow == OAuth2Flow.AUTH_CODE) {
            query.put("response_type", (Object)"code");
        }
        if ((redirectUri = credentials.getNormalizedRedirectUri()) != null && !redirectUri.isBlank()) {
            query.put("redirect_uri", (Object)redirectUri);
        }
        if (credentials.getScopes() != null) {
            query.put("scope", (Object)String.join((CharSequence)this.options.getScopeSeparator(), credentials.getScopes()));
        }
        if ((state = credentials.getState()) != null && !state.isBlank()) {
            query.put("state", (Object)state);
        }
        if ((clientId = this.options.getClientId()) != null) {
            query.put("client_id", (Object)clientId);
        } else {
            if (this.options.getClientAssertionType() != null) {
                query.put("client_assertion_type", (Object)this.options.getClientAssertionType());
            }
            if (this.options.getClientAssertion() != null) {
                query.put("client_assertion", (Object)this.options.getClientAssertion());
            }
        }
        return this.options.getAuthorizationPath() + "?" + AuthUtils.jsonToQuery(query);
    }

    public CompletableFuture<JSONObject> token(String grantType, JSONObject params) {
        boolean confidentialClient;
        if (grantType == null) {
            return CompletableFuture.failedFuture(new IllegalArgumentException("Token request requires a grantType other than null"));
        }
        JSONObject headers = new JSONObject();
        boolean bl = confidentialClient = this.options.getClientId() != null && this.options.getClientSecret() != null;
        if (confidentialClient) {
            String basic = this.options.getClientId() + ":" + this.options.getClientSecret();
            headers.put("Authorization", (Object)("Basic " + (String)Encoders.BASE64URL.encode((Object)basic.getBytes(StandardCharsets.UTF_8))));
        }
        JSONObject form = new JSONObject(params.toString());
        if (this.options.getExtraParams() != null) {
            for (String key : JSONObject.getNames((JSONObject)this.options.getExtraParams())) {
                form.put(key, this.options.getExtraParams().get(key));
            }
        }
        form.put("grant_type", (Object)grantType);
        if (!confidentialClient) {
            String clientId = this.options.getClientId();
            if (clientId != null) {
                form.put("client_id", (Object)clientId);
            } else {
                if (this.options.getClientAssertionType() != null) {
                    form.put("client_assertion_type", (Object)this.options.getClientAssertionType());
                }
                if (this.options.getClientAssertion() != null) {
                    form.put("client_assertion", (Object)this.options.getClientAssertion());
                }
            }
        }
        headers.put("Content-Type", (Object)"application/x-www-form-urlencoded");
        String payload = AuthUtils.jsonToQuery(form);
        headers.put("Accept", (Object)"application/json,application/x-www-form-urlencoded;q=0.9");
        return this.fetch(HttpMethod.POST, this.options.getTokenPath(), headers, payload).thenCompose(response -> {
            JSONObject json;
            if (response.body() == null || ((String)response.body()).isEmpty()) {
                return CompletableFuture.failedFuture(new RuntimeException("No Body"));
            }
            HttpHeaders header = response.headers();
            if (AuthUtils.containsValue(header, "application/json")) {
                json = new JSONObject((String)response.body());
            } else if (AuthUtils.containsValue(header, "application/x-www-form-urlencoded") || AuthUtils.containsValue(header, "text/plain")) {
                json = AuthUtils.queryToJson((String)response.body());
            } else {
                return CompletableFuture.failedFuture(new RuntimeException("Cannot handle content type: " + String.valueOf(header.map().get("Content-Type"))));
            }
            if (json == null || json.has("error")) {
                return CompletableFuture.failedFuture(new RuntimeException(AuthUtils.extractErrorDescription(json)));
            }
            AuthUtils.processNonStandardHeaders(json, response, this.options.getScopeSeparator());
            return CompletableFuture.completedFuture(json);
        });
    }

    public CompletableFuture<JSONObject> tokenIntrospection(String tokenType, String token) {
        boolean confidentialClient;
        JSONObject headers = new JSONObject();
        boolean bl = confidentialClient = this.options.getClientId() != null && this.options.getClientSecret() != null;
        if (confidentialClient) {
            String basic = this.options.getClientId() + ":" + this.options.getClientSecret();
            headers.put("Authorization", (Object)("Basic " + (String)Encoders.BASE64URL.encode((Object)basic.getBytes(StandardCharsets.UTF_8))));
        }
        JSONObject form = new JSONObject().put("token", (Object)token).put("token_type_hint", (Object)tokenType);
        headers.put("Content-Type", (Object)"application/x-www-form-urlencoded");
        String payload = AuthUtils.jsonToQuery(form);
        headers.put("Accept", (Object)"application/json,application/x-www-form-urlencoded;q=0.9");
        return this.fetch(HttpMethod.POST, this.options.getIntrospectionPath(), headers, payload).thenCompose(response -> {
            JSONObject json;
            if (response.body() == null || ((String)response.body()).isEmpty()) {
                return CompletableFuture.failedFuture(new RuntimeException("No Body"));
            }
            if (AuthUtils.containsValue(response.headers(), "application/json")) {
                json = new JSONObject((String)response.body());
            } else if (AuthUtils.containsValue(response.headers(), "application/x-www-form-urlencoded") || AuthUtils.containsValue(response.headers(), "text/plain")) {
                json = AuthUtils.queryToJson((String)response.body());
            } else {
                return CompletableFuture.failedFuture(new RuntimeException("Cannot handle accessToken type: " + String.valueOf(response.headers().allValues("Content-Type"))));
            }
            if (json == null || json.has("error")) {
                return CompletableFuture.failedFuture(new RuntimeException(AuthUtils.extractErrorDescription(json)));
            }
            AuthUtils.processNonStandardHeaders(json, response, this.options.getScopeSeparator());
            return CompletableFuture.completedFuture(json);
        });
    }

    public CompletableFuture<Void> tokenRevocation(@NotNull String tokenType, @NotNull String token) {
        boolean confidentialClient;
        if (token == null) {
            return CompletableFuture.failedFuture(new RuntimeException("Cannot revoke null token"));
        }
        JSONObject headers = new JSONObject();
        headers.put("Content-Type", (Object)"application/x-www-form-urlencoded");
        boolean bl = confidentialClient = this.options.getClientId() != null && this.options.getClientSecret() != null;
        if (confidentialClient) {
            String basic = this.options.getClientId() + ":" + this.options.getClientSecret();
            headers.put("Authorization", (Object)("Basic " + (String)Encoders.BASE64URL.encode((Object)basic.getBytes(StandardCharsets.UTF_8))));
        }
        JSONObject form = new JSONObject().put("token", (Object)token).put("token_type_hint", (Object)tokenType);
        String payload = AuthUtils.jsonToQuery(form);
        headers.put("Accept", (Object)"application/json,application/x-www-form-urlencoded;q=0.9");
        return this.fetch(HttpMethod.POST, this.options.getRevocationPath(), headers, payload).thenCompose(response -> {
            if (response.body() == null) {
                return CompletableFuture.failedFuture(new RuntimeException("No Body"));
            }
            return CompletableFuture.completedFuture(null);
        });
    }

    public CompletableFuture<JSONObject> userInfo(String accessToken) {
        JSONObject headers = new JSONObject();
        JSONObject extraParams = this.options.getExtraParams();
        Object path = this.options.getUserInfoPath();
        if (path == null) {
            return CompletableFuture.failedFuture(new AuthenticationException("userInfo path is not configured"));
        }
        if (extraParams != null) {
            path = (String)path + "?" + AuthUtils.jsonToQuery(extraParams);
        }
        headers.put("Authorization", (Object)("Bearer " + accessToken));
        headers.put("Accept", (Object)"application/json,application/jwt,application/x-www-form-urlencoded;q=0.9");
        return this.fetch(HttpMethod.GET, (String)path, headers, null).thenCompose(response -> {
            JSONObject userInfo;
            String body = (String)response.body();
            if (body == null) {
                return CompletableFuture.failedFuture(new AuthenticationException("No Body"));
            }
            if (AuthUtils.containsValue(response.headers(), "application/json")) {
                userInfo = new JSONObject(body);
            } else if (AuthUtils.containsValue(response.headers(), "applications/jwt")) {
                Jwe jwt = Jwts.parser().build().parseEncryptedContent((CharSequence)body);
                JSONObject jwtHeader = new JSONObject((Map)jwt.getHeader());
                JSONObject jwtPayload = new JSONObject(jwt.getPayload());
                userInfo = new JSONObject().put("header", (Object)jwtHeader).put("payload", (Object)jwtPayload);
            } else if (AuthUtils.containsValue(response.headers(), "application/x-www-form-urlencoded") || AuthUtils.containsValue(response.headers(), "text/plain")) {
                userInfo = AuthUtils.queryToJson(body);
            } else {
                return CompletableFuture.failedFuture(new AuthenticationException("Cannot handle Content-Type: " + String.valueOf(response.headers().allValues("Content-Type"))));
            }
            AuthUtils.processNonStandardHeaders(userInfo, response, this.options.getScopeSeparator());
            return CompletableFuture.completedFuture(userInfo);
        });
    }

    public CompletableFuture<JSONObject> jwkSet() {
        JSONObject headers = new JSONObject();
        headers.put("Accept", (Object)"application/jwk-set+json, application/json");
        return this.fetch(HttpMethod.GET, this.options.getJwkPath(), headers, null).thenCompose(response -> {
            if (response.body() == null || ((String)response.body()).isEmpty()) {
                return CompletableFuture.failedFuture(new RuntimeException("No Body"));
            }
            if (!AuthUtils.containsValue(response.headers(), "application/jwk-set+json") && !AuthUtils.containsValue(response.headers(), "application/json")) {
                return CompletableFuture.failedFuture(new RuntimeException("Cannot handle content type: " + String.valueOf(response.headers().allValues("Content-Type"))));
            }
            JSONObject json = new JSONObject((String)response.body());
            if (json.has("error")) {
                return CompletableFuture.failedFuture(new RuntimeException(AuthUtils.extractErrorDescription(json)));
            }
            List<String> cacheControl = response.headers().allValues(CACHE_CONTROL);
            if (cacheControl != null) {
                for (String header : cacheControl) {
                    Matcher match;
                    if (header.length() <= 8 || !(match = MAX_AGE.matcher(header)).find()) continue;
                    try {
                        json.put("maxAge", (Object)Long.valueOf(match.group(1)));
                        break;
                    }
                    catch (RuntimeException runtimeException) {
                    }
                }
            }
            return CompletableFuture.completedFuture(json);
        });
    }

    public CompletableFuture<OpenIDAuthenticationProvider> discover(Stage stage, OAuth2Options config) {
        if (config.getSite() == null) {
            CompletableFuture.failedFuture(new RuntimeException("the site url cannot be null"));
        }
        String oidc_discovery_path = "/.well-known/openid-configuration";
        String issuer = config.getSite();
        if (issuer.endsWith("/.well-known/openid-configuration")) {
            issuer = issuer.substring(0, issuer.length() - "/.well-known/openid-configuration".length());
        }
        return this.fetch(HttpMethod.GET, issuer + "/.well-known/openid-configuration", new JSONObject().put("Accept", (Object)"application/json"), null).thenCompose(response -> {
            String issuerEndpoint;
            if (response.statusCode() != 200) {
                return CompletableFuture.failedFuture(new RuntimeException("Bad Response [" + response.statusCode() + "] " + (String)response.body()));
            }
            if (!AuthUtils.containsValue(response.headers(), "application/json")) {
                return CompletableFuture.failedFuture(new RuntimeException("Cannot handle content type: " + String.valueOf(response.headers().allValues("Content-Type"))));
            }
            JSONObject json = new JSONObject((String)response.body());
            if (json.has("error")) {
                return CompletableFuture.failedFuture(new RuntimeException(AuthUtils.extractErrorDescription(json)));
            }
            config.setAuthorizationPath(json.optString("authorization_endpoint", null));
            config.setTokenPath(json.optString("token_endpoint", null));
            config.setLogoutPath(json.optString("end_session_endpoint", null));
            config.setRevocationPath(json.optString("revocation_endpoint", null));
            config.setUserInfoPath(json.optString("userinfo_endpoint", null));
            config.setJwkPath(json.optString("jwks_uri", null));
            config.setIntrospectionPath(json.optString("introspection_endpoint", null));
            if (json.has("issuer")) {
                JWTOptions jwtOptions = config.getJWTOptions();
                if (jwtOptions == null) {
                    jwtOptions = new JWTOptions();
                    config.setJWTOptions(jwtOptions);
                }
                jwtOptions.setIssuer(json.getString("issuer"));
            }
            if (config.isValidateIssuer() && (issuerEndpoint = json.getString("issuer")) != null) {
                if (issuerEndpoint.endsWith("/")) {
                    issuerEndpoint = issuerEndpoint.substring(0, issuerEndpoint.length() - 1);
                }
                if (!issuerEndpoint.equals(config.getJWTOptions().getIssuer())) {
                    return CompletableFuture.failedFuture(new RuntimeException("Issuer validation failed: received [" + issuerEndpoint + "] but expected [" + config.getJWTOptions().getIssuer() + "]"));
                }
            }
            config.setSupportedResponseTypes(null);
            if (json.has("response_types_supported")) {
                JSONArray responseTypes = json.getJSONArray("response_types_supported");
                responseTypes.forEach(responseType -> config.addSupportedResponseType((String)responseType));
            }
            config.setSupportedResponseModes(null);
            if (json.has("response_modes_supported")) {
                JSONArray responseModes = json.getJSONArray("response_modes_supported");
                responseModes.forEach(responseMode -> config.addSupportedResponseMode((String)responseMode));
            }
            config.setSupportedGrantTypes(null);
            if (json.has("grant_types_supported") && config.getFlow() != null) {
                JSONArray flows = json.getJSONArray("grant_types_supported");
                flows.forEach(grantType -> config.addSupportedGrantType((String)grantType));
                if (!flows.toList().contains(config.getFlow().getGrantType())) {
                    return CompletableFuture.failedFuture(new RuntimeException("Unsupported flow: " + config.getFlow().getGrantType() + ", allowed: " + String.valueOf(flows)));
                }
            }
            config.setSupportedSubjectTypes(null);
            if (json.has("subject_types_supported")) {
                JSONArray subjectTypes = json.getJSONArray("subject_types_supported");
                subjectTypes.forEach(subjectType -> config.addSupportedSubjectType((String)subjectType));
            }
            config.setSupportedScopes(null);
            if (json.has("scopes_supported")) {
                JSONArray scopes = json.getJSONArray("scopes_supported");
                scopes.forEach(scope -> config.addSupportedScope((String)scope));
            }
            config.setSupportedIdTokenSigningAlgValues(null);
            if (json.has("id_token_signing_alg_values_supported")) {
                JSONArray idTokenSigningAlgValues = json.getJSONArray("id_token_signing_alg_values_supported");
                idTokenSigningAlgValues.forEach(idTokenSigningAlgValue -> config.addSupportedIdTokenSigningAlgValue((String)idTokenSigningAlgValue));
            }
            config.setSupportedTokenEndpointAuthMethods(null);
            if (json.has("token_endpoint_auth_methods_supported")) {
                JSONArray tokenEndpointAuthMethods = json.getJSONArray("token_endpoint_auth_methods_supported");
                tokenEndpointAuthMethods.forEach(tokenEndpointAuthMethod -> config.addSupportedTokenEndpointAuthMethod((String)tokenEndpointAuthMethod));
            }
            config.setSupportedClaims(null);
            if (json.has("claims_supported")) {
                JSONArray claims = json.getJSONArray("claims_supported");
                claims.forEach(claim -> config.addSupportedClaim((String)claim));
            }
            config.setSupportedCodeChallengeMethods(null);
            if (json.has("code_challenge_methods_supported")) {
                JSONArray codeChallengeMethods = json.getJSONArray("code_challenge_methods_supported");
                codeChallengeMethods.forEach(codeChallengeMethod -> config.addSupportedCodeChallengeMethod((String)codeChallengeMethod));
            }
            config.setSupportedIntrospectionEndpointAuthMethods(null);
            if (json.has("introspection_endpoint_auth_methods_supported")) {
                JSONArray introspectionEndpointAuthMethods = json.getJSONArray("introspection_endpoint_auth_methods_supported");
                introspectionEndpointAuthMethods.forEach(introspectionEndpointAuthMethod -> config.addSupportedIntrospectionEndpointAuthMethod((String)introspectionEndpointAuthMethod));
            }
            config.setSupportedRevocationEndpointAuthMethods(null);
            if (json.has("revocation_endpoint_auth_methods_supported")) {
                JSONArray revocationEndpointAuthMethods = json.getJSONArray("revocation_endpoint_auth_methods_supported");
                revocationEndpointAuthMethods.forEach(revocationEndpointAuthMethod -> config.addSupportedRevocationEndpointAuthMethod((String)revocationEndpointAuthMethod));
            }
            config.setSupportedRequestParameter(false);
            if (json.has("request_parameter_supported")) {
                config.setSupportedRequestParameter(json.getBoolean("request_parameter_supported"));
            }
            config.setSupportedRequestObjectSigningAlgValues(null);
            if (json.has("request_object_signing_alg_values_supported")) {
                JSONArray requestObjectSigningAlgValues = json.getJSONArray("request_object_signing_alg_values_supported");
                requestObjectSigningAlgValues.forEach(requestObjectSigningAlgValue -> config.addSupportedRequestObjectSigningAlgValue((String)requestObjectSigningAlgValue));
            }
            return CompletableFuture.completedFuture(new OpenIDAuthenticationProvider(stage, config));
        });
    }

    public CompletableFuture<Void> logout(@NotNull String accessToken, @Nullable String refreshToken) {
        JSONObject headers = new JSONObject();
        headers.put("Authorization", (Object)("Bearer " + accessToken));
        JSONObject form = new JSONObject();
        form.put("client_id", (Object)this.options.getClientId());
        if (this.options.getClientSecret() != null) {
            form.put("client_secret", (Object)this.options.getClientSecret());
        }
        if (refreshToken != null) {
            form.put("refresh_token", (Object)refreshToken);
        }
        headers.put("Content-Type", (Object)"application/x-www-form-urlencoded");
        String payload = AuthUtils.jsonToQuery(form);
        headers.put("Accept", (Object)"application/json,application/x-www-form-urlencoded;q=0.9");
        return this.fetch(HttpMethod.POST, this.options.getLogoutPath(), headers, payload).thenCompose(response -> {
            if (response.statusCode() < 200 || response.statusCode() >= 300) {
                return CompletableFuture.failedFuture(new RuntimeException("Bad Response [" + response.statusCode() + "] " + (String)response.body()));
            }
            return CompletableFuture.completedFuture(null);
        });
    }

    protected CompletableFuture<HttpResponse<String>> fetch(HttpMethod method, String path, JSONObject headers, String payload) {
        if (path == null || path.isEmpty()) {
            return CompletableFuture.failedFuture(new IllegalArgumentException("Invalid path"));
        }
        String url = path.charAt(0) == '/' ? this.options.getSite() + path : path;
        HttpRequest.Builder requestBuilder = HttpRequest.newBuilder().uri(URI.create(url));
        JSONObject tmp = this.options.getHeaders();
        if (tmp != null) {
            for (Map.Entry kv : tmp.toMap().entrySet()) {
                requestBuilder.header((String)kv.getKey(), (String)kv.getValue());
            }
        }
        if (headers != null) {
            for (Map.Entry kv : headers.toMap().entrySet()) {
                requestBuilder.header((String)kv.getKey(), (String)kv.getValue());
            }
        }
        if (this.options.getUserAgent() != null) {
            requestBuilder.header("User-Agent", this.options.getUserAgent());
        }
        if (method != HttpMethod.POST && method != HttpMethod.PATCH && method != HttpMethod.PUT) {
            payload = null;
        }
        return this.makeRequest(requestBuilder, payload);
    }

    private CompletableFuture<HttpResponse<String>> makeRequest(HttpRequest.Builder requestBuilder, String payload) {
        if (payload != null) {
            requestBuilder.POST(HttpRequest.BodyPublishers.ofByteArray(payload.getBytes()));
        }
        return this.httpClient.sendAsync(requestBuilder.build(), HttpResponse.BodyHandlers.ofString()).thenCompose(response -> {
            if (response.statusCode() < 200 || response.statusCode() >= 300) {
                JSONObject error;
                if (response.body() == null || ((String)response.body()).isEmpty()) {
                    return CompletableFuture.failedFuture(new RuntimeException("Status code: " + response.statusCode()));
                }
                if (AuthUtils.containsValue(response.headers(), "application/json") && !(error = new JSONObject((String)response.body())).optString("error").isEmpty()) {
                    if (!error.optString("error_description").isEmpty()) {
                        return CompletableFuture.failedFuture(new RuntimeException(error.getString("error") + ": " + error.getString("error_description")));
                    }
                    return CompletableFuture.failedFuture(new RuntimeException(error.getString("error")));
                }
                return CompletableFuture.failedFuture(new RuntimeException(response.statusCode() + ": " + (String)response.body()));
            }
            return CompletableFuture.completedFuture(response);
        });
    }
}

