/*
 * Decompiled with CFR 0.152.
 */
package one.jpro.platform.auth.core.oauth2;

import com.jpro.webapi.WebAPI;
import io.jsonwebtoken.Claims;
import io.jsonwebtoken.ExpiredJwtException;
import io.jsonwebtoken.Identifiable;
import io.jsonwebtoken.Jws;
import io.jsonwebtoken.JwsHeader;
import io.jsonwebtoken.JwtException;
import io.jsonwebtoken.JwtParser;
import io.jsonwebtoken.Jwts;
import io.jsonwebtoken.io.Decoders;
import io.jsonwebtoken.io.Encoders;
import io.jsonwebtoken.io.Parser;
import io.jsonwebtoken.security.Jwk;
import io.jsonwebtoken.security.JwkSet;
import io.jsonwebtoken.security.Jwks;
import java.io.IOException;
import java.net.InetAddress;
import java.net.URI;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.nio.charset.StandardCharsets;
import java.security.Key;
import java.time.Instant;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Collectors;
import javafx.stage.Stage;
import one.jpro.platform.auth.core.authentication.AuthenticationException;
import one.jpro.platform.auth.core.authentication.AuthenticationProvider;
import one.jpro.platform.auth.core.authentication.CredentialValidationException;
import one.jpro.platform.auth.core.authentication.Credentials;
import one.jpro.platform.auth.core.authentication.User;
import one.jpro.platform.auth.core.basic.UsernamePasswordCredentials;
import one.jpro.platform.auth.core.http.HttpServer;
import one.jpro.platform.auth.core.jwt.JWTOptions;
import one.jpro.platform.auth.core.jwt.TokenCredentials;
import one.jpro.platform.auth.core.jwt.TokenExpiredException;
import one.jpro.platform.auth.core.oauth2.OAuth2API;
import one.jpro.platform.auth.core.oauth2.OAuth2Credentials;
import one.jpro.platform.auth.core.oauth2.OAuth2Flow;
import one.jpro.platform.auth.core.oauth2.OAuth2Options;
import one.jpro.platform.auth.core.oauth2.provider.OpenIDAuthenticationProvider;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.json.JSONArray;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OAuth2AuthenticationProvider
implements AuthenticationProvider<Credentials> {
    private static final Logger logger = LoggerFactory.getLogger(OAuth2AuthenticationProvider.class);
    @Nullable
    private final Stage stage;
    @NotNull
    private final OAuth2API api;
    @NotNull
    private final OAuth2Options options;
    private HttpServer httpServer;

    public OAuth2AuthenticationProvider(@Nullable Stage stage, @NotNull OAuth2API api) {
        this.stage = stage;
        this.api = Objects.requireNonNull(api, "OAuth2 api cannot be null");
        this.options = api.getOptions();
        this.options.validate();
        this.httpServer = HttpServer.create(stage);
    }

    public OAuth2AuthenticationProvider(@Nullable Stage stage, @NotNull OAuth2Options options) {
        this(stage, new OAuth2API(options));
    }

    @NotNull
    public final OAuth2Options getOptions() {
        return this.options;
    }

    public CompletableFuture<String> authorizeUrl(@NotNull OAuth2Credentials credentials) {
        Objects.requireNonNull(credentials, "OAuth2Credentials cannot be null");
        String authorizeUrl = this.api.authorizeURL(credentials.setNormalizedRedirectUri(this.normalizeUri(credentials.getRedirectUri())));
        logger.debug("Authorize URL: {}", (Object)authorizeUrl);
        if (!WebAPI.isBrowser()) {
            if (this.httpServer != null) {
                this.httpServer.stop();
            }
            this.httpServer = HttpServer.create(this.stage);
        }
        return this.httpServer.openURL(authorizeUrl);
    }

    @Override
    public CompletableFuture<User> authenticate(@NotNull Credentials credentials) {
        try {
            if (credentials instanceof UsernamePasswordCredentials) {
                UsernamePasswordCredentials usernamePasswordCredentials = (UsernamePasswordCredentials)credentials;
                usernamePasswordCredentials.validate(null);
                OAuth2Credentials oauth2Credentials = new OAuth2Credentials().setUsername(usernamePasswordCredentials.getUsername()).setPassword(usernamePasswordCredentials.getPassword()).setFlow(OAuth2Flow.PASSWORD);
                return this.authenticate(oauth2Credentials);
            }
            if (credentials instanceof TokenCredentials) {
                TokenCredentials tokenCredentials = (TokenCredentials)credentials;
                tokenCredentials.validate(null);
                try {
                    User newUser = this.createUser(new JSONObject().put("access_token", (Object)tokenCredentials.getToken()));
                    return CompletableFuture.completedFuture(newUser);
                }
                catch (IllegalStateException | TokenExpiredException ex) {
                    logger.error(ex.getMessage(), (Throwable)ex);
                    if (this.options.getIntrospectionPath() == null) {
                        return CompletableFuture.failedFuture(new RuntimeException("Can't authenticate `access_token`: no introspection support"));
                    }
                    return this.api.tokenIntrospection("access_token", tokenCredentials.getToken()).thenCompose(json -> {
                        String clientId;
                        if (json.has("active") && json.getBoolean("active")) {
                            return CompletableFuture.failedFuture(new RuntimeException("Inactive Token"));
                        }
                        if (json.has("client_id") && (clientId = this.options.getClientId()) != null && !clientId.equals(json.getString("client_id"))) {
                            logger.info("Introspect `client_id` doesn't match configured `client_id`");
                        }
                        try {
                            return CompletableFuture.completedFuture(this.createUser((JSONObject)json));
                        }
                        catch (IllegalStateException | TokenExpiredException ex) {
                            return CompletableFuture.failedFuture(ex);
                        }
                    });
                }
            }
            OAuth2Credentials oauth2Credentials = (OAuth2Credentials)credentials;
            JSONObject queryParams = new JSONObject(this.httpServer.getQueryParams());
            logger.debug("URL query parameters: {}", (Object)queryParams);
            if (queryParams.has("code")) {
                oauth2Credentials.setCode(queryParams.getString("code"));
                if (oauth2Credentials.getCode().isBlank()) {
                    return CompletableFuture.failedFuture(new RuntimeException("Authorization code is missing"));
                }
            }
            if (queryParams.has("scope")) {
                String[] scopes = queryParams.getString("scope").split("\\+");
                oauth2Credentials.setScopes(List.of(scopes));
            }
            JSONObject params = new JSONObject();
            OAuth2Flow flow = oauth2Credentials.getFlow() != null ? oauth2Credentials.getFlow() : this.options.getFlow();
            oauth2Credentials.validate(flow);
            if (this.options.getSupportedGrantTypes() != null && !this.options.getSupportedGrantTypes().isEmpty() && !this.options.getSupportedGrantTypes().contains(flow.getGrantType())) {
                return CompletableFuture.failedFuture(new RuntimeException("Provided flow is not supported by provider"));
            }
            switch (flow) {
                case AUTH_CODE: {
                    params.put("code", (Object)oauth2Credentials.getCode());
                    if (oauth2Credentials.getRedirectUri() != null) {
                        params.put("redirect_uri", (Object)this.normalizeUri(oauth2Credentials.getRedirectUri()));
                    }
                    if (oauth2Credentials.getCodeVerifier() == null) break;
                    params.put("code_verifier", (Object)oauth2Credentials.getCodeVerifier());
                    break;
                }
                case PASSWORD: {
                    params.put("username", (Object)oauth2Credentials.getUsername()).put("password", (Object)oauth2Credentials.getPassword());
                    if (oauth2Credentials.getScopes() == null) break;
                    params.put("scope", (Object)String.join((CharSequence)this.options.getScopeSeparator(), oauth2Credentials.getScopes()));
                    break;
                }
                case CLIENT: {
                    if (oauth2Credentials.getScopes() == null) break;
                    params.put("scope", (Object)String.join((CharSequence)this.options.getScopeSeparator(), oauth2Credentials.getScopes()));
                    break;
                }
                case AUTH_JWT: {
                    if (oauth2Credentials.getAssertion() != null) {
                        params.put("assertion", (Object)oauth2Credentials.getAssertion());
                    }
                    if (oauth2Credentials.getScopes() == null) break;
                    params.put("scope", (Object)String.join((CharSequence)this.options.getScopeSeparator(), oauth2Credentials.getScopes()));
                    break;
                }
                default: {
                    return CompletableFuture.failedFuture(new RuntimeException("Current flow does not allow acquiring a token by the replay party"));
                }
            }
            return this.api.token(flow.getGrantType(), params).thenCompose(json -> {
                try {
                    User newUser = this.createUser((JSONObject)json);
                    oauth2Credentials.setUsername(newUser.getName());
                    return CompletableFuture.completedFuture(newUser);
                }
                catch (IllegalStateException | TokenExpiredException ex) {
                    return CompletableFuture.failedFuture(ex);
                }
            });
        }
        catch (ClassCastException | CredentialValidationException ex) {
            return CompletableFuture.failedFuture(ex);
        }
    }

    public CompletableFuture<OpenIDAuthenticationProvider> discover() {
        return this.api.discover(this.stage, this.options);
    }

    public CompletableFuture<JSONObject> introspect(User user, String tokenType) {
        return this.api.tokenIntrospection(tokenType, user.toJSON().getJSONObject("attributes").optJSONObject("auth").get(tokenType).toString());
    }

    public CompletableFuture<User> refresh(User user) throws IllegalStateException {
        String refreshToken = user.toJSON().getJSONObject("attributes").optJSONObject("auth").optString("refresh_token");
        if (refreshToken == null || refreshToken.isBlank()) {
            return CompletableFuture.failedFuture(new IllegalStateException("refresh_token is null or missing"));
        }
        return this.api.token("refresh_token", new JSONObject().put("refresh_token", (Object)refreshToken)).thenCompose(json -> {
            try {
                return CompletableFuture.completedFuture(this.createUser((JSONObject)json));
            }
            catch (IllegalStateException | TokenExpiredException ex) {
                return CompletableFuture.failedFuture(ex);
            }
        });
    }

    public CompletableFuture<Void> revoke(User user, String tokenType) {
        return this.api.tokenRevocation(tokenType, user.toJSON().getJSONObject("attributes").optJSONObject("auth").get(tokenType).toString());
    }

    public CompletableFuture<JSONObject> userInfo(@NotNull User user) {
        Objects.requireNonNull(user, "User must not be null");
        JSONObject authJSON = user.toJSON().getJSONObject("attributes").getJSONObject("auth");
        return this.api.userInfo(authJSON.getString("access_token")).thenCompose(json -> {
            String userSub;
            JSONObject accessTokenJSON = authJSON.optJSONObject("accessToken");
            if (accessTokenJSON != null && accessTokenJSON.has("sub") && !(userSub = accessTokenJSON.getString("sub")).equals(json.getString("sub"))) {
                return CompletableFuture.failedFuture(new AuthenticationException("User subject does not match UserInfo subject"));
            }
            if (json.has("token")) {
                try {
                    this.verifyToken(json.getString("token"), false);
                }
                catch (IllegalStateException | TokenExpiredException ex) {
                    return CompletableFuture.failedFuture(ex);
                }
            }
            return CompletableFuture.completedFuture(json);
        });
    }

    public CompletableFuture<Void> logout(@NotNull User user) {
        JSONObject authJSON = user.toJSON().getJSONObject("attributes").getJSONObject("auth");
        String accessToken = authJSON.getString("access_token");
        String refreshToken = authJSON.optString("refresh_token");
        return this.api.logout(accessToken, refreshToken);
    }

    private User createUser(@NotNull JSONObject json) throws TokenExpiredException, IllegalStateException {
        JSONObject payload;
        String token;
        Objects.requireNonNull(json, "json can not be null");
        JSONObject userJSON = new JSONObject();
        JSONObject authJSON = new JSONObject(json.toString());
        if (json.has("access_token")) {
            token = json.getString("access_token");
            try {
                JSONObject verifiedAccessToken = this.verifyToken(token, false);
                authJSON.put("accessToken", (Object)verifiedAccessToken);
                payload = verifiedAccessToken.getJSONObject("payload");
                if (payload.has("name")) {
                    userJSON.put("name", (Object)payload.getString("name"));
                } else if (payload.has("email")) {
                    userJSON.put("name", (Object)payload.getString("email"));
                }
                authJSON.put("claimToken", (Object)"accessToken");
            }
            catch (JwtException | IllegalStateException ex) {
                logger.error("Cannot decode/verify access token:", ex);
            }
        }
        if (json.has("id_token")) {
            token = json.getString("id_token");
            try {
                JSONObject verifiedIdToken = this.verifyToken(token, true);
                authJSON.put("idToken", (Object)verifiedIdToken);
                payload = verifiedIdToken.getJSONObject("payload");
                if (payload.has("name")) {
                    userJSON.put("name", (Object)payload.getString("name"));
                } else if (payload.has("email")) {
                    userJSON.put("name", (Object)payload.getString("email"));
                }
            }
            catch (JwtException | IllegalStateException ex) {
                logger.error("Cannot decode/verify id token:", ex);
            }
        }
        userJSON.put("attributes", (Object)new JSONObject().put("auth", (Object)authJSON));
        return new User(userJSON);
    }

    private JSONObject verifyToken(String token, boolean idToken) throws TokenExpiredException, IllegalStateException {
        List<String> audList;
        JSONArray audience;
        JSONObject json;
        block20: {
            json = new JSONObject();
            json.put("token", (Object)token);
            json.put("token_type", (Object)(idToken ? "id_token" : "access_token"));
            try {
                if (this.options.isVerifyToken()) {
                    try (HttpClient httpClient = HttpClient.newHttpClient();){
                        String webKeys = httpClient.send(HttpRequest.newBuilder(URI.create(this.options.getJwkPath())).build(), HttpResponse.BodyHandlers.ofString()).body();
                        Map<String, Key> keyMap = ((JwkSet)((Parser)Jwks.setParser().build()).parse((CharSequence)webKeys)).getKeys().stream().collect(Collectors.toMap(Identifiable::getId, Jwk::toKey));
                        JwtParser jwtParser = Jwts.parser().keyLocator(header -> (Key)keyMap.get(header.getOrDefault((Object)"kid", (Object)"").toString())).build();
                        Jws jws = jwtParser.parseSignedClaims((CharSequence)token);
                        Optional.ofNullable((JwsHeader)jws.getHeader()).ifPresent(header -> json.put("header", (Object)new JSONObject((Map)header)));
                        Optional.ofNullable((Claims)jws.getPayload()).ifPresent(payload -> json.put("payload", (Object)new JSONObject((Map)payload)));
                        Optional.ofNullable(jws.getDigest()).ifPresent(digest -> json.put("signature", Encoders.BASE64URL.encode(digest)));
                        break block20;
                    }
                }
                String[] parts = token.split("\\.");
                if (parts.length < 2) {
                    throw new IllegalStateException("Invalid JWT token");
                }
                String headerString = new String((byte[])Decoders.BASE64URL.decode((Object)parts[0]), StandardCharsets.UTF_8);
                json.put("header", (Object)new JSONObject(headerString));
                String payloadString = new String((byte[])Decoders.BASE64URL.decode((Object)parts[1]), StandardCharsets.UTF_8);
                json.put("payload", (Object)new JSONObject(payloadString));
                if (parts.length > 2) {
                    json.put("signature", (Object)parts[2]);
                }
            }
            catch (ExpiredJwtException e) {
                throw new TokenExpiredException(e.getMessage(), e.getClaims() != null ? e.getClaims().getExpiration().toInstant() : Instant.now());
            }
            catch (JwtException | IOException | InterruptedException e) {
                throw new IllegalStateException(e.getMessage());
            }
        }
        JWTOptions jwtOptions = this.options.getJWTOptions();
        JSONObject payload2 = json.getJSONObject("payload");
        if (payload2.has("aud")) {
            audience = payload2.getJSONArray("aud");
            if (audience.isEmpty()) {
                throw new IllegalStateException("User audience is null or empty");
            }
            if (!idToken && jwtOptions.getAudience() != null) {
                audList = audience.toList().stream().map(Object::toString).toList();
                for (String aud : jwtOptions.getAudience()) {
                    if (audList.contains(aud)) continue;
                    throw new IllegalStateException("Invalid JWT audience, expected: " + aud + ", actual: " + String.valueOf(audience));
                }
            }
        }
        if (jwtOptions.getIssuer() != null && !jwtOptions.getIssuer().equals(payload2.getString("iss"))) {
            throw new IllegalStateException("Invalid JWT issuer, expected: " + jwtOptions.getIssuer() + ", actual: " + payload2.getString("iss"));
        }
        if (idToken && payload2.has("azp")) {
            if (!this.options.getClientId().equals(payload2.getString("azp"))) {
                throw new IllegalStateException("Invalid authorized party, expected: " + this.options.getClientId() + ", actual: " + payload2.getString("azp"));
            }
            audience = payload2.optJSONArray("aud");
            if (audience != null && audience.length() > 1 && !(audList = audience.toList().stream().map(Object::toString).toList()).contains(payload2.getString("azp"))) {
                throw new IllegalStateException("ID token with multiple audiences does not contain 'azp' claim value");
            }
        }
        return json;
    }

    private boolean hasExpired(User user) {
        JSONObject jwtInfo;
        if (user.getAttributes().containsKey("auth") && (jwtInfo = (JSONObject)user.getAttributes().get("auth")).has("exp")) {
            Instant expiredAt = Instant.ofEpochMilli(jwtInfo.getLong("exp"));
            return expiredAt.isBefore(Instant.now());
        }
        return false;
    }

    private String normalizeUri(String uri) {
        if (this.httpServer != null && uri != null && uri.charAt(0) == '/') {
            int port = this.httpServer.getServerPort();
            Object server = this.httpServer.getServerHost();
            boolean isLocalAddress = ((String)server).equals("localhost");
            if (this.options.isUseLoopbackIpAddress() && isLocalAddress) {
                server = InetAddress.getLoopbackAddress().getHostAddress();
            }
            if (port > 0) {
                server = (String)server + ":" + port;
            }
            String serverUrl = isLocalAddress ? "http://" + (String)server : "https://" + (String)server;
            return serverUrl + uri;
        }
        return uri;
    }
}

