/*
 * Decompiled with CFR 0.152.
 */
package one.jpro.platform.auth.core.utils;

import java.net.URLDecoder;
import java.net.URLEncoder;
import java.net.http.HttpHeaders;
import java.net.http.HttpResponse;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import one.jpro.platform.auth.core.crypto.PasswordEncoder;
import one.jpro.platform.auth.core.crypto.bcrypt.BCryptPasswordEncoder;
import org.json.JSONArray;
import org.json.JSONObject;

public interface AuthUtils {
    public static final PasswordEncoder BCRYPT_PASSWORD_ENCODER = new BCryptPasswordEncoder();

    public static String requireNonNullOrBlank(String str, String message) {
        if (str == null) {
            throw new NullPointerException(message);
        }
        if (str.isBlank()) {
            throw new IllegalArgumentException(message);
        }
        return str;
    }

    public static String jsonToQuery(JSONObject json) {
        return json.toMap().entrySet().stream().filter(entry -> entry.getValue() != null && !entry.getValue().toString().isBlank()).map(entry -> URLEncoder.encode((String)entry.getKey(), StandardCharsets.UTF_8) + "=" + URLEncoder.encode(entry.getValue().toString(), StandardCharsets.UTF_8)).collect(Collectors.joining("&"));
    }

    public static JSONObject queryToJson(String query) {
        String[] pairs;
        if (query == null) {
            return null;
        }
        JSONObject json = new JSONObject();
        for (String pair : pairs = query.split("&")) {
            JSONArray array;
            String value;
            int idx = pair.indexOf("=");
            String key = idx > 0 ? URLDecoder.decode(pair.substring(0, idx), StandardCharsets.UTF_8) : pair;
            String string = value = idx > 0 && pair.length() > idx + 1 ? URLDecoder.decode(pair.substring(idx + 1), StandardCharsets.UTF_8) : null;
            if (!json.has(key)) {
                json.put(key, value);
                continue;
            }
            Object oldValue = json.get(key);
            if (oldValue instanceof JSONArray) {
                array = (JSONArray)oldValue;
            } else {
                array = new JSONArray();
                array.put(oldValue);
                json.put(key, (Object)array);
            }
            array.put(Objects.requireNonNullElse(value, JSONObject.NULL));
        }
        return json;
    }

    public static Object findValueByKey(JSONObject json, String key) {
        if (json.has(key)) {
            return json.get(key);
        }
        for (String currentKey : json.keySet()) {
            Object value = json.get(currentKey);
            if (value instanceof JSONObject) {
                Object result = AuthUtils.findValueByKey((JSONObject)value, key);
                if (result == null) continue;
                return result;
            }
            if (!(value instanceof JSONArray)) continue;
            JSONArray array = (JSONArray)value;
            for (int i = 0; i < array.length(); ++i) {
                Object result;
                Object arrayElement = array.get(i);
                if (!(arrayElement instanceof JSONObject) || (result = AuthUtils.findValueByKey((JSONObject)arrayElement, key)) == null) continue;
                return result;
            }
        }
        return null;
    }

    public static boolean containsValue(HttpHeaders headers, String value) {
        return headers.map().entrySet().stream().flatMap(entry -> ((List)entry.getValue()).stream()).anyMatch(s -> s.contains(value));
    }

    public static void processNonStandardHeaders(JSONObject json, HttpResponse<String> response, String scopeSeparator) {
        Optional<String> xOAuthScopes = response.headers().firstValue("X-OAuth-Scopes");
        Optional<String> xAcceptedOAuthScopes = response.headers().firstValue("X-OAuth-Scopes");
        xOAuthScopes.ifPresent(scopes -> {
            if (json.has("scope")) {
                json.put("scope", (Object)(json.getString("scope") + scopeSeparator + scopes));
            } else {
                json.put("scope", scopes);
            }
        });
        xAcceptedOAuthScopes.ifPresent(scopes -> json.put("acceptedScopes", scopes));
    }

    public static String extractErrorDescription(JSONObject json) {
        String description;
        if (json == null) {
            return "null";
        }
        Object object = json.get("error");
        if (object instanceof JSONObject) {
            JSONObject error = (JSONObject)object;
            description = error.getString("message");
        } else {
            description = json.optString("error_description", json.getString("error"));
        }
        if (description == null) {
            return "null";
        }
        return description;
    }

    public static String decodePercent(String str) {
        return URLDecoder.decode(str, StandardCharsets.UTF_8);
    }
}

