/*
 * Decompiled with CFR 0.152.
 */
package one.jpro.platform.auth.core.api;

import javafx.stage.Stage;
import one.jpro.platform.auth.core.api.FluentKeycloakAuth;
import one.jpro.platform.auth.core.oauth2.OAuth2Flow;
import one.jpro.platform.auth.core.oauth2.provider.KeycloakAuthenticationProvider;
import org.json.JSONObject;

public class FluentKeycloakAuthAPI
implements FluentKeycloakAuth {
    private OAuth2Flow flow = OAuth2Flow.AUTH_CODE;
    private String site;
    private String clientId;
    private String clientSecret;
    private String realm;
    private String redirectUri;

    @Override
    public FluentKeycloakAuth flow(OAuth2Flow flow) {
        this.flow = flow;
        return this;
    }

    @Override
    public FluentKeycloakAuth site(String site) {
        this.site = site;
        return this;
    }

    @Override
    public FluentKeycloakAuth clientId(String clientId) {
        this.clientId = clientId;
        return this;
    }

    @Override
    public FluentKeycloakAuth clientSecret(String clientSecret) {
        this.clientSecret = clientSecret;
        return this;
    }

    @Override
    public FluentKeycloakAuth realm(String realm) {
        this.realm = realm;
        return this;
    }

    @Override
    public FluentKeycloakAuth redirectUri(String redirectUri) {
        this.redirectUri = redirectUri;
        return this;
    }

    @Override
    public KeycloakAuthenticationProvider create(Stage stage) {
        JSONObject config = new JSONObject();
        if (this.site != null) {
            config.put("auth-server-url", (Object)this.site);
        }
        if (this.clientId != null) {
            config.put("resource", (Object)this.clientId);
        }
        if (this.clientSecret != null) {
            config.put("credentials", (Object)new JSONObject().put("secret", (Object)this.clientSecret));
        }
        if (this.realm != null) {
            config.put("realm", (Object)this.realm);
        }
        KeycloakAuthenticationProvider keycloakAuthProvider = new KeycloakAuthenticationProvider(stage, this.flow, config);
        keycloakAuthProvider.getCredentials().setRedirectUri(this.redirectUri);
        return keycloakAuthProvider;
    }
}

