/*
 * Decompiled with CFR 0.152.
 */
package one.jpro.platform.auth.core.oauth2;

import java.util.List;
import java.util.Optional;
import java.util.stream.Collector;
import java.util.stream.Stream;
import one.jpro.platform.auth.core.authentication.CredentialValidationException;
import one.jpro.platform.auth.core.authentication.Credentials;
import one.jpro.platform.auth.core.oauth2.OAuth2Flow;
import org.json.JSONArray;
import org.json.JSONObject;

public class OAuth2Credentials
implements Credentials {
    private String code;
    private String codeVerifier;
    private String redirectUri;
    private JSONObject jwt;
    private String assertion;
    private String password;
    private String username;
    private List<String> scopes;
    private OAuth2Flow flow;
    private String nonce;
    private String state;
    private String normalizedRedirectUri;

    public String getCode() {
        return this.code;
    }

    public OAuth2Credentials setCode(String code) {
        this.code = code;
        return this;
    }

    public String getCodeVerifier() {
        return this.codeVerifier;
    }

    public OAuth2Credentials setCodeVerifier(String codeVerifier) {
        this.codeVerifier = codeVerifier;
        return this;
    }

    public String getRedirectUri() {
        return this.redirectUri;
    }

    public OAuth2Credentials setRedirectUri(String redirectUri) {
        this.redirectUri = redirectUri;
        return this;
    }

    public JSONObject getJwt() {
        return this.jwt;
    }

    public OAuth2Credentials setJwt(JSONObject jwt) {
        this.jwt = jwt;
        return this;
    }

    public String getAssertion() {
        return this.assertion;
    }

    public OAuth2Credentials setAssertion(String assertion) {
        this.assertion = assertion;
        return this;
    }

    public String getPassword() {
        return this.password;
    }

    public OAuth2Credentials setPassword(String password) {
        this.password = password;
        return this;
    }

    public String getUsername() {
        return this.username;
    }

    public OAuth2Credentials setUsername(String username) {
        this.username = username;
        return this;
    }

    public List<String> getScopes() {
        return this.scopes;
    }

    public OAuth2Credentials setScopes(List<String> scopes) {
        this.scopes = scopes;
        return this;
    }

    public OAuth2Flow getFlow() {
        return this.flow;
    }

    public OAuth2Credentials setFlow(OAuth2Flow flow) {
        this.flow = flow;
        return this;
    }

    public String getNonce() {
        return this.nonce;
    }

    public OAuth2Credentials setNonce(String nonce) {
        this.nonce = nonce;
        return this;
    }

    public String getState() {
        return this.state;
    }

    public OAuth2Credentials setState(String state) {
        this.state = state;
        return this;
    }

    public String getNormalizedRedirectUri() {
        if (this.normalizedRedirectUri == null) {
            return this.redirectUri;
        }
        return this.normalizedRedirectUri;
    }

    OAuth2Credentials setNormalizedRedirectUri(String completeRedirectUri) {
        this.normalizedRedirectUri = completeRedirectUri;
        return this;
    }

    @Override
    public <V> void validate(V arg) throws CredentialValidationException {
        OAuth2Flow flow = (OAuth2Flow)((Object)arg);
        if (flow == null) {
            throw new CredentialValidationException("flow cannot be null");
        }
        switch (flow) {
            case AUTH_CODE: {
                if (this.code == null || this.code.isBlank()) {
                    throw new CredentialValidationException("code cannot be null or blank");
                }
                if (this.redirectUri == null || !this.redirectUri.isBlank()) break;
                throw new CredentialValidationException("redirectUri cannot be blank");
            }
            case PASSWORD: {
                if (this.username == null || this.username.isBlank()) {
                    throw new CredentialValidationException("username cannot be null or blank");
                }
                if (this.password != null && !this.password.isBlank()) break;
                throw new CredentialValidationException("password cannot be null or blank");
            }
            case AUTH_JWT: {
                if (this.jwt != null) break;
                throw new CredentialValidationException("jwt cannot be null");
            }
        }
    }

    @Override
    public JSONObject toJSON() {
        JSONObject json = new JSONObject();
        Optional.ofNullable(this.getCode()).ifPresent(code -> json.put("code", code));
        Optional.ofNullable(this.getCodeVerifier()).ifPresent(codeVerifier -> json.put("code_verifier", codeVerifier));
        Optional.ofNullable(this.getNormalizedRedirectUri()).ifPresent(redirectUri -> json.put("redirect_uri", redirectUri));
        Optional.ofNullable(this.getFlow()).ifPresent(flow -> json.put("flow", (Object)flow.getGrantType()));
        Optional.ofNullable(this.getJwt()).ifPresent(jwt -> json.put("jwt", jwt));
        Optional.ofNullable(this.getAssertion()).ifPresent(assertion -> json.put("assertion", assertion));
        Optional.ofNullable(this.getPassword()).ifPresent(password -> json.put("password", password));
        Optional.ofNullable(this.getUsername()).ifPresent(username -> json.put("username", username));
        Optional.ofNullable(Stream.ofNullable(this.getScopes()).collect(Collector.of(JSONArray::new, JSONArray::putAll, JSONArray::putAll, new Collector.Characteristics[0]))).filter(jsonArray -> !jsonArray.isEmpty()).ifPresent(jsonArray -> json.put("scopes", jsonArray));
        Optional.ofNullable(this.getNonce()).ifPresent(nonce -> json.put("nonce", nonce));
        Optional.ofNullable(this.getState()).ifPresent(state -> json.put("state", state));
        return json;
    }

    public String toString() {
        return this.toJSON().toString();
    }
}

