/*
 * Decompiled with CFR 0.152.
 */
package one.jpro.platform.auth.core.oauth2;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collector;
import java.util.stream.Stream;
import one.jpro.platform.auth.core.authentication.Options;
import one.jpro.platform.auth.core.jwt.JWTOptions;
import one.jpro.platform.auth.core.oauth2.OAuth2Flow;
import one.jpro.platform.auth.core.oauth2.PubSecKeyOptions;
import one.jpro.platform.auth.core.utils.AuthUtils;
import org.jetbrains.annotations.Nullable;
import org.json.JSONArray;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OAuth2Options
implements Options {
    private static final Logger logger = LoggerFactory.getLogger(OAuth2Options.class);
    private static final OAuth2Flow FLOW = OAuth2Flow.AUTH_CODE;
    private static final String AUTHORIZATION_PATH = "/oauth/authorize";
    private static final String TOKEN_PATH = "/oauth/token";
    private static final String REVOCATION_PATH = "/oauth/revoke";
    private static final JWTOptions JWT_OPTIONS = new JWTOptions();
    private static final String SCOPE_SEPARATOR = " ";
    private static final boolean VERIFY_TOKEN = true;
    private static final boolean VALIDATE_ISSUER = true;
    private static final boolean USE_LOOPBACK_IP_ADDRESS = false;
    private static final long JWK_DEFAULT_AGE = -1L;
    private static final Pattern TENANT_PATTERN = Pattern.compile("\\{(tenant|tenantid|realm)}");
    private OAuth2Flow flow;
    private List<String> supportedResponseTypes;
    private List<String> supportedResponseModes;
    private List<String> supportedGrantTypes;
    private List<String> supportedSubjectTypes;
    private List<String> supportedScopes;
    private List<String> supportedIdTokenSigningAlgValues;
    private List<String> supportedTokenEndpointAuthMethods;
    private List<String> supportedClaims;
    private List<String> supportedCodeChallengeMethods;
    private List<String> supportedIntrospectionEndpointAuthMethods;
    private List<String> supportedRevocationEndpointAuthMethods;
    private boolean supportedRequestParameter;
    private List<String> supportedRequestObjectSigningAlgValues;
    private String authorizationPath;
    private String tokenPath;
    private String revocationPath;
    private String scopeSeparator;
    private boolean verifyToken;
    private boolean validateIssuer;
    private boolean useLoopbackIpAddress;
    private String logoutPath;
    private String userInfoPath;
    private JSONObject userInfoParams;
    private String introspectionPath;
    private String jwkPath;
    private long jwkMaxAge;
    private String tenant;
    private String site;
    private String clientId;
    private String clientSecret;
    private String clientAssertionType;
    private String clientAssertion;
    private String userAgent;
    private JSONObject headers;
    private List<PubSecKeyOptions> pubSecKeys;
    private JWTOptions jwtOptions;
    private JSONObject extraParams;

    public OAuth2Options() {
        this.flow = FLOW;
        this.verifyToken = true;
        this.validateIssuer = true;
        this.useLoopbackIpAddress = false;
        this.authorizationPath = AUTHORIZATION_PATH;
        this.tokenPath = TOKEN_PATH;
        this.revocationPath = REVOCATION_PATH;
        this.scopeSeparator = SCOPE_SEPARATOR;
        this.jwtOptions = JWT_OPTIONS;
        this.jwkMaxAge = -1L;
    }

    public OAuth2Options(OAuth2Options other) {
        this.flow = other.flow;
        this.supportedResponseTypes = other.supportedResponseTypes;
        this.supportedResponseModes = other.supportedResponseModes;
        this.supportedGrantTypes = other.supportedGrantTypes;
        this.supportedSubjectTypes = other.supportedSubjectTypes;
        this.supportedScopes = other.supportedScopes;
        this.supportedIdTokenSigningAlgValues = other.supportedIdTokenSigningAlgValues;
        this.supportedTokenEndpointAuthMethods = other.supportedTokenEndpointAuthMethods;
        this.supportedClaims = other.supportedClaims;
        this.supportedCodeChallengeMethods = other.supportedCodeChallengeMethods;
        this.supportedIntrospectionEndpointAuthMethods = other.supportedIntrospectionEndpointAuthMethods;
        this.supportedRevocationEndpointAuthMethods = other.supportedRevocationEndpointAuthMethods;
        this.supportedRequestParameter = other.supportedRequestParameter;
        this.supportedRequestObjectSigningAlgValues = other.supportedRequestObjectSigningAlgValues;
        this.authorizationPath = other.authorizationPath;
        this.tokenPath = other.tokenPath;
        this.revocationPath = other.revocationPath;
        this.scopeSeparator = other.scopeSeparator;
        this.verifyToken = other.verifyToken;
        this.validateIssuer = other.validateIssuer;
        this.logoutPath = other.logoutPath;
        this.userInfoPath = other.userInfoPath;
        this.introspectionPath = other.introspectionPath;
        this.jwkPath = other.jwkPath;
        this.jwkMaxAge = other.jwkMaxAge;
        this.tenant = other.tenant;
        this.site = other.site;
        this.clientId = other.clientId;
        this.clientSecret = other.clientSecret;
        this.clientAssertionType = other.clientAssertionType;
        this.clientAssertion = other.clientAssertion;
        this.userAgent = other.userAgent;
        this.pubSecKeys = other.pubSecKeys;
        this.jwtOptions = other.jwtOptions;
        if (other.extraParams != null) {
            this.extraParams = new JSONObject(other.extraParams.toString());
        }
        if (other.headers != null) {
            this.headers = new JSONObject(other.headers.toString());
        }
        if (other.userInfoParams != null) {
            this.userInfoParams = new JSONObject(other.userInfoParams.toString());
        }
    }

    public OAuth2Flow getFlow() {
        return this.flow;
    }

    public OAuth2Options setFlow(OAuth2Flow flow) {
        this.flow = flow;
        return this;
    }

    public List<String> getSupportedResponseTypes() {
        return this.supportedResponseTypes;
    }

    public OAuth2Options setSupportedResponseTypes(List<String> supportedResponseTypes) {
        this.supportedResponseTypes = supportedResponseTypes;
        return this;
    }

    public OAuth2Options addSupportedResponseType(String supportedResponseType) {
        if (this.supportedResponseTypes == null) {
            this.supportedResponseTypes = new ArrayList<String>();
        }
        this.supportedResponseTypes.add(supportedResponseType);
        return this;
    }

    public List<String> getSupportedResponseModes() {
        return this.supportedResponseModes;
    }

    public OAuth2Options setSupportedResponseModes(List<String> supportedResponseModes) {
        this.supportedResponseModes = supportedResponseModes;
        return this;
    }

    public OAuth2Options addSupportedResponseMode(String supportedResponseMode) {
        if (this.supportedResponseModes == null) {
            this.supportedResponseModes = new ArrayList<String>();
        }
        this.supportedResponseModes.add(supportedResponseMode);
        return this;
    }

    public List<String> getSupportedGrantTypes() {
        return this.supportedGrantTypes;
    }

    public OAuth2Options setSupportedGrantTypes(List<String> supportedGrantTypes) {
        this.supportedGrantTypes = supportedGrantTypes;
        return this;
    }

    public OAuth2Options addSupportedGrantType(String supportedGrantType) {
        if (this.supportedGrantTypes == null) {
            this.supportedGrantTypes = new ArrayList<String>();
        }
        this.supportedGrantTypes.add(supportedGrantType);
        return this;
    }

    public List<String> getSupportedSubjectTypes() {
        return this.supportedSubjectTypes;
    }

    public OAuth2Options setSupportedSubjectTypes(List<String> supportedSubjectTypes) {
        this.supportedSubjectTypes = supportedSubjectTypes;
        return this;
    }

    public OAuth2Options addSupportedSubjectType(String supportedSubjectType) {
        if (this.supportedSubjectTypes == null) {
            this.supportedSubjectTypes = new ArrayList<String>();
        }
        this.supportedSubjectTypes.add(supportedSubjectType);
        return this;
    }

    public List<String> getSupportedIdTokenSigningAlgValues() {
        return this.supportedIdTokenSigningAlgValues;
    }

    public OAuth2Options setSupportedIdTokenSigningAlgValues(List<String> supportedIdTokenSigningAlgValues) {
        this.supportedIdTokenSigningAlgValues = supportedIdTokenSigningAlgValues;
        return this;
    }

    public OAuth2Options addSupportedIdTokenSigningAlgValue(String supportedIdTokenSigningAlgValue) {
        if (this.supportedIdTokenSigningAlgValues == null) {
            this.supportedIdTokenSigningAlgValues = new ArrayList<String>();
        }
        this.supportedIdTokenSigningAlgValues.add(supportedIdTokenSigningAlgValue);
        return this;
    }

    public List<String> getSupportedScopes() {
        return this.supportedScopes;
    }

    public OAuth2Options setSupportedScopes(List<String> supportedScopes) {
        this.supportedScopes = supportedScopes;
        return this;
    }

    public OAuth2Options addSupportedScope(String supportedScope) {
        if (this.supportedScopes == null) {
            this.supportedScopes = new ArrayList<String>();
        }
        this.supportedScopes.add(supportedScope);
        return this;
    }

    public List<String> getSupportedTokenEndpointAuthMethods() {
        return this.supportedTokenEndpointAuthMethods;
    }

    public OAuth2Options setSupportedTokenEndpointAuthMethods(List<String> supportedTokenEndpointAuthMethods) {
        this.supportedTokenEndpointAuthMethods = supportedTokenEndpointAuthMethods;
        return this;
    }

    public OAuth2Options addSupportedTokenEndpointAuthMethod(String supportedTokenEndpointAuthMethod) {
        if (this.supportedTokenEndpointAuthMethods == null) {
            this.supportedTokenEndpointAuthMethods = new ArrayList<String>();
        }
        this.supportedTokenEndpointAuthMethods.add(supportedTokenEndpointAuthMethod);
        return this;
    }

    public List<String> getSupportedClaims() {
        return this.supportedClaims;
    }

    public OAuth2Options setSupportedClaims(List<String> supportedClaims) {
        this.supportedClaims = supportedClaims;
        return this;
    }

    public OAuth2Options addSupportedClaim(String supportedClaim) {
        if (this.supportedClaims == null) {
            this.supportedClaims = new ArrayList<String>();
        }
        this.supportedClaims.add(supportedClaim);
        return this;
    }

    public List<String> getSupportedCodeChallengeMethods() {
        return this.supportedCodeChallengeMethods;
    }

    public OAuth2Options setSupportedCodeChallengeMethods(List<String> supportedCodeChallengeMethods) {
        this.supportedCodeChallengeMethods = supportedCodeChallengeMethods;
        return this;
    }

    public OAuth2Options addSupportedCodeChallengeMethod(String supportedCodeChallengeMethod) {
        if (this.supportedCodeChallengeMethods == null) {
            this.supportedCodeChallengeMethods = new ArrayList<String>();
        }
        this.supportedCodeChallengeMethods.add(supportedCodeChallengeMethod);
        return this;
    }

    public List<String> getSupportedIntrospectionEndpointAuthMethods() {
        return this.supportedIntrospectionEndpointAuthMethods;
    }

    public OAuth2Options setSupportedIntrospectionEndpointAuthMethods(List<String> supportedIntrospectionEndpointAuthMethods) {
        this.supportedIntrospectionEndpointAuthMethods = supportedIntrospectionEndpointAuthMethods;
        return this;
    }

    public OAuth2Options addSupportedIntrospectionEndpointAuthMethod(String supportedIntrospectionEndpointAuthMethod) {
        if (this.supportedIntrospectionEndpointAuthMethods == null) {
            this.supportedIntrospectionEndpointAuthMethods = new ArrayList<String>();
        }
        this.supportedIntrospectionEndpointAuthMethods.add(supportedIntrospectionEndpointAuthMethod);
        return this;
    }

    public List<String> getSupportedRevocationEndpointAuthMethods() {
        return this.supportedRevocationEndpointAuthMethods;
    }

    public OAuth2Options setSupportedRevocationEndpointAuthMethods(List<String> supportedRevocationEndpointAuthMethods) {
        this.supportedRevocationEndpointAuthMethods = supportedRevocationEndpointAuthMethods;
        return this;
    }

    public OAuth2Options addSupportedRevocationEndpointAuthMethod(String supportedRevocationEndpointAuthMethod) {
        if (this.supportedRevocationEndpointAuthMethods == null) {
            this.supportedRevocationEndpointAuthMethods = new ArrayList<String>();
        }
        this.supportedRevocationEndpointAuthMethods.add(supportedRevocationEndpointAuthMethod);
        return this;
    }

    public boolean isSupportedRequestParameter() {
        return this.supportedRequestParameter;
    }

    public OAuth2Options setSupportedRequestParameter(boolean supportedRequestParameter) {
        this.supportedRequestParameter = supportedRequestParameter;
        return this;
    }

    public List<String> getSupportedRequestObjectSigningAlgValues() {
        return this.supportedRequestObjectSigningAlgValues;
    }

    public OAuth2Options setSupportedRequestObjectSigningAlgValues(List<String> supportedRequestObjectSigningAlgValues) {
        this.supportedRequestObjectSigningAlgValues = supportedRequestObjectSigningAlgValues;
        return this;
    }

    public OAuth2Options addSupportedRequestObjectSigningAlgValue(String supportedRequestObjectSigningAlgValue) {
        if (this.supportedRequestObjectSigningAlgValues == null) {
            this.supportedRequestObjectSigningAlgValues = new ArrayList<String>();
        }
        this.supportedRequestObjectSigningAlgValues.add(supportedRequestObjectSigningAlgValue);
        return this;
    }

    public String getAuthorizationPath() {
        return this.computePath(this.authorizationPath);
    }

    public OAuth2Options setAuthorizationPath(String authorizationPath) {
        this.authorizationPath = authorizationPath;
        return this;
    }

    public String getTokenPath() {
        return this.computePath(this.tokenPath);
    }

    public OAuth2Options setTokenPath(String tokenPath) {
        this.tokenPath = tokenPath;
        return this;
    }

    public String getRevocationPath() {
        return this.computePath(this.revocationPath);
    }

    public OAuth2Options setRevocationPath(String revocationPath) {
        this.revocationPath = revocationPath;
        return this;
    }

    public String getScopeSeparator() {
        return this.scopeSeparator;
    }

    public OAuth2Options setScopeSeparator(String scopeSeparator) {
        this.scopeSeparator = scopeSeparator;
        return this;
    }

    public boolean isVerifyToken() {
        return this.verifyToken;
    }

    public OAuth2Options setVerifyToken(boolean verifyToken) {
        this.verifyToken = verifyToken;
        return this;
    }

    public boolean isValidateIssuer() {
        return this.validateIssuer;
    }

    public OAuth2Options setValidateIssuer(boolean validateIssuer) {
        this.validateIssuer = validateIssuer;
        return this;
    }

    public boolean isUseLoopbackIpAddress() {
        return this.useLoopbackIpAddress;
    }

    public OAuth2Options setUseLoopbackIpAddress(boolean useLoopbackIpAddress) {
        this.useLoopbackIpAddress = useLoopbackIpAddress;
        return this;
    }

    public String getLogoutPath() {
        return this.computePath(this.logoutPath);
    }

    public OAuth2Options setLogoutPath(String logoutPath) {
        this.logoutPath = logoutPath;
        return this;
    }

    public String getUserInfoPath() {
        return this.computePath(this.userInfoPath);
    }

    public OAuth2Options setUserInfoPath(String userInfoPath) {
        this.userInfoPath = userInfoPath;
        return this;
    }

    public JSONObject getUserInfoParams() {
        return this.userInfoParams;
    }

    public OAuth2Options setUserInfoParams(JSONObject userInfoParams) {
        this.userInfoParams = userInfoParams;
        return this;
    }

    public String getIntrospectionPath() {
        return this.computePath(this.introspectionPath);
    }

    public OAuth2Options setIntrospectionPath(String introspectionPath) {
        this.introspectionPath = introspectionPath;
        return this;
    }

    public String getJwkPath() {
        return this.computePath(this.jwkPath);
    }

    public OAuth2Options setJwkPath(String jwkPath) {
        this.jwkPath = jwkPath;
        return this;
    }

    public long getJwkMaxAge() {
        return this.jwkMaxAge;
    }

    public OAuth2Options setJwkMaxAge(long jwkMaxAge) {
        this.jwkMaxAge = jwkMaxAge;
        return this;
    }

    public String getTenant() {
        return this.tenant;
    }

    public OAuth2Options setTenant(String tenant) {
        this.tenant = tenant;
        return this;
    }

    public String getSite() {
        if (this.site != null && this.site.endsWith("/")) {
            this.site = this.site.substring(0, this.site.length() - 1);
        }
        return this.replaceVariables(this.site);
    }

    public OAuth2Options setSite(String site) {
        this.site = site;
        return this;
    }

    public String getClientId() {
        return this.clientId;
    }

    public OAuth2Options setClientId(String clientId) {
        this.clientId = AuthUtils.requireNonNullOrBlank(clientId, "Client id cannot be null or blank");
        return this;
    }

    public String getClientSecret() {
        return this.clientSecret;
    }

    public OAuth2Options setClientSecret(String clientSecret) {
        this.clientSecret = AuthUtils.requireNonNullOrBlank(clientSecret, "Client secret cannot be null or blank");
        return this;
    }

    public String getClientAssertionType() {
        return this.clientAssertionType;
    }

    public OAuth2Options setClientAssertionType(String clientAssertionType) {
        this.clientAssertionType = clientAssertionType;
        return this;
    }

    public String getClientAssertion() {
        return this.clientAssertion;
    }

    public OAuth2Options setClientAssertion(String clientAssertion) {
        this.clientAssertion = clientAssertion;
        return this;
    }

    public String getUserAgent() {
        return this.userAgent;
    }

    public OAuth2Options setUserAgent(String userAgent) {
        this.userAgent = userAgent;
        return this;
    }

    public JSONObject getHeaders() {
        return this.headers;
    }

    public OAuth2Options setHeaders(JSONObject headers) {
        this.headers = headers;
        return this;
    }

    public List<PubSecKeyOptions> getPubSecKeys() {
        return this.pubSecKeys;
    }

    public OAuth2Options setPubSecKeys(List<PubSecKeyOptions> pubSecKeys) {
        this.pubSecKeys = pubSecKeys;
        return this;
    }

    public OAuth2Options addPubSecKeys(PubSecKeyOptions pubSecKey) {
        if (this.pubSecKeys == null) {
            this.pubSecKeys = new ArrayList<PubSecKeyOptions>();
        }
        this.pubSecKeys.add(pubSecKey);
        return this;
    }

    public JWTOptions getJWTOptions() {
        return this.jwtOptions;
    }

    public OAuth2Options setJWTOptions(JWTOptions jwtOptions) {
        this.jwtOptions = jwtOptions;
        return this;
    }

    public JSONObject getExtraParams() {
        return this.extraParams;
    }

    public OAuth2Options setExtraParams(JSONObject extraParams) {
        this.extraParams = extraParams;
        return this;
    }

    private String computePath(String path) {
        if (path != null && ((String)path).charAt(0) == '/' && this.site != null) {
            if (this.site.endsWith("/")) {
                this.site = this.site.substring(0, this.site.length() - 1);
            }
            path = this.site + (String)path;
        }
        return this.replaceVariables((String)path);
    }

    public String replaceVariables(@Nullable String path) {
        Matcher matcher;
        if (path != null && (matcher = TENANT_PATTERN.matcher(path)).find()) {
            if (this.tenant == null || this.tenant.isBlank()) {
                throw new IllegalStateException("The tenant value is null or blank.");
            }
            return matcher.replaceAll(this.tenant);
        }
        return path;
    }

    public void validate() throws IllegalStateException {
        if (this.flow == null) {
            throw new IllegalStateException("Missing OAuth2 flow: [AUTH_CODE, PASSWORD, CLIENT, AUTH_JWT]");
        }
        switch (this.flow) {
            case AUTH_CODE: 
            case AUTH_JWT: {
                if (this.clientAssertion == null && this.clientAssertionType == null) {
                    if (this.clientId != null) break;
                    throw new IllegalStateException("Missing configuration: [clientId]");
                }
                if (this.clientAssertion != null && this.clientAssertionType != null) break;
                throw new IllegalStateException("Missing configuration: [clientAssertion] and [clientAssertionType]");
            }
            case PASSWORD: {
                if (this.clientAssertion == null && this.clientAssertionType == null) {
                    if (this.clientId != null) break;
                    logger.debug("If you are using Client OAuth2 Resource Owner flow, please specify [clientId]");
                    break;
                }
                if (this.clientAssertion != null && this.clientAssertionType != null) break;
                throw new IllegalStateException("Missing configuration: [clientAssertion] and [clientAssertionType]");
            }
        }
    }

    @Override
    public JSONObject toJSON() {
        JSONObject json = new JSONObject();
        Optional.ofNullable(this.getFlow()).ifPresent(flow -> json.put("flow", (Object)flow.getGrantType()));
        Optional.ofNullable(this.getSite()).ifPresent(site -> json.put("site", site));
        Optional.ofNullable(this.getClientId()).ifPresent(clientId -> json.put("client_id", clientId));
        Optional.ofNullable(this.getClientSecret()).ifPresent(clientSecret -> json.put("client_secret", clientSecret));
        Optional.ofNullable(this.getTenant()).ifPresent(tenant -> json.put("tenant", tenant));
        Optional.ofNullable(Stream.ofNullable(this.getSupportedResponseTypes()).collect(Collector.of(JSONArray::new, JSONArray::putAll, JSONArray::putAll, new Collector.Characteristics[0]))).filter(jsonArray -> !jsonArray.isEmpty()).ifPresent(jsonArray -> json.put("supported_response_types", jsonArray));
        Optional.ofNullable(Stream.ofNullable(this.getSupportedResponseModes()).collect(Collector.of(JSONArray::new, JSONArray::putAll, JSONArray::putAll, new Collector.Characteristics[0]))).filter(jsonArray -> !jsonArray.isEmpty()).ifPresent(jsonArray -> json.put("supported_response_modes", jsonArray));
        Optional.ofNullable(Stream.ofNullable(this.getSupportedGrantTypes()).collect(Collector.of(JSONArray::new, JSONArray::putAll, JSONArray::putAll, new Collector.Characteristics[0]))).filter(jsonArray -> !jsonArray.isEmpty()).ifPresent(jsonArray -> json.put("supported_grant_types", jsonArray));
        Optional.ofNullable(Stream.ofNullable(this.getSupportedSubjectTypes()).collect(Collector.of(JSONArray::new, JSONArray::putAll, JSONArray::putAll, new Collector.Characteristics[0]))).filter(jsonArray -> !jsonArray.isEmpty()).ifPresent(jsonArray -> json.put("supported_subject_types", jsonArray));
        Optional.ofNullable(Stream.ofNullable(this.getSupportedScopes()).collect(Collector.of(JSONArray::new, JSONArray::putAll, JSONArray::putAll, new Collector.Characteristics[0]))).filter(jsonArray -> !jsonArray.isEmpty()).ifPresent(jsonArray -> json.put("supported_scopes", jsonArray));
        Optional.ofNullable(Stream.ofNullable(this.getSupportedIdTokenSigningAlgValues()).collect(Collector.of(JSONArray::new, JSONArray::putAll, JSONArray::putAll, new Collector.Characteristics[0]))).filter(jsonArray -> !jsonArray.isEmpty()).ifPresent(jsonArray -> json.put("supported_id_token_signing_alg_values", jsonArray));
        Optional.ofNullable(Stream.ofNullable(this.getSupportedTokenEndpointAuthMethods()).collect(Collector.of(JSONArray::new, JSONArray::putAll, JSONArray::putAll, new Collector.Characteristics[0]))).filter(jsonArray -> !jsonArray.isEmpty()).ifPresent(jsonArray -> json.put("supported_token_endpoint_auth_methods", jsonArray));
        Optional.ofNullable(Stream.ofNullable(this.getSupportedClaims()).collect(Collector.of(JSONArray::new, JSONArray::putAll, JSONArray::putAll, new Collector.Characteristics[0]))).filter(jsonArray -> !jsonArray.isEmpty()).ifPresent(jsonArray -> json.put("supported_claims", jsonArray));
        Optional.ofNullable(Stream.ofNullable(this.getSupportedCodeChallengeMethods()).collect(Collector.of(JSONArray::new, JSONArray::putAll, JSONArray::putAll, new Collector.Characteristics[0]))).filter(jsonArray -> !jsonArray.isEmpty()).ifPresent(jsonArray -> json.put("supported_code_challenge_methods", jsonArray));
        Optional.ofNullable(Stream.ofNullable(this.getSupportedIntrospectionEndpointAuthMethods()).collect(Collector.of(JSONArray::new, JSONArray::putAll, JSONArray::putAll, new Collector.Characteristics[0]))).filter(jsonArray -> !jsonArray.isEmpty()).ifPresent(jsonArray -> json.put("supported_introspection_endpoint_auth_methods", jsonArray));
        Optional.ofNullable(Stream.ofNullable(this.getSupportedRevocationEndpointAuthMethods()).collect(Collector.of(JSONArray::new, JSONArray::putAll, JSONArray::putAll, new Collector.Characteristics[0]))).filter(jsonArray -> !jsonArray.isEmpty()).ifPresent(jsonArray -> json.put("supported_revocation_endpoint_auth_methods", jsonArray));
        json.put("supported_request_parameter", this.isSupportedRequestParameter());
        Optional.ofNullable(Stream.ofNullable(this.getSupportedRequestObjectSigningAlgValues()).collect(Collector.of(JSONArray::new, JSONArray::putAll, JSONArray::putAll, new Collector.Characteristics[0]))).filter(jsonArray -> !jsonArray.isEmpty()).ifPresent(jsonArray -> json.put("supported_request_object_signing_alg_values", jsonArray));
        Optional.ofNullable(this.getAuthorizationPath()).ifPresent(authorizationPath -> json.put("authorization_path", authorizationPath));
        Optional.ofNullable(this.getTokenPath()).ifPresent(tokenPath -> json.put("token_path", tokenPath));
        Optional.ofNullable(this.getRevocationPath()).ifPresent(revocationPath -> json.put("revocation_path", revocationPath));
        Optional.ofNullable(this.getScopeSeparator()).ifPresent(scopeSeparator -> json.put("scope_separator", scopeSeparator));
        json.put("validate_issuer", this.isValidateIssuer());
        Optional.ofNullable(this.getLogoutPath()).ifPresent(logoutPath -> json.put("end_session_endpoint", logoutPath));
        Optional.ofNullable(this.getUserInfoPath()).ifPresent(userInfoPath -> json.put("user_info_path", userInfoPath));
        Optional.ofNullable(this.getIntrospectionPath()).ifPresent(introspectionPath -> json.put("introspection_path", introspectionPath));
        Optional.ofNullable(this.getJwkPath()).ifPresent(jwks_uri -> json.put("jwks_uri", jwks_uri));
        json.put("jwk_max_age", this.getJwkMaxAge());
        Optional.ofNullable(this.getClientAssertion()).ifPresent(clientAssertion -> json.put("client_assertion", clientAssertion));
        Optional.ofNullable(this.getClientAssertionType()).ifPresent(clientAssertionType -> json.put("client_assertion_type", clientAssertionType));
        Optional.ofNullable(this.getUserAgent()).ifPresent(userAgent -> json.put("user_agent", userAgent));
        Optional.ofNullable(this.getPubSecKeys()).ifPresent(pubSecKeyOptions -> json.put("pub_sec_keys", (Collection)pubSecKeyOptions));
        Optional.ofNullable(this.getJWTOptions()).ifPresent(jwtOptions -> json.put("jwt_options", (Object)jwtOptions.toJSON()));
        Optional.ofNullable(this.getExtraParams()).ifPresent(extraParams -> json.put("extra_params", extraParams));
        Optional.ofNullable(this.getHeaders()).ifPresent(headers -> json.put("headers", headers));
        Optional.ofNullable(this.getUserInfoParams()).ifPresent(userInfoParams -> json.put("user_info_params", userInfoParams));
        return json;
    }
}

