/*
 * Decompiled with CFR 0.152.
 */
package one.jpro.platform.auth.core.authentication;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import one.jpro.platform.auth.core.authentication.AuthenticationException;
import one.jpro.platform.auth.core.authentication.AuthenticationProvider;
import one.jpro.platform.auth.core.authentication.CredentialValidationException;
import one.jpro.platform.auth.core.authentication.Credentials;
import one.jpro.platform.auth.core.authentication.User;
import org.jetbrains.annotations.NotNull;

public class CombineAuthenticationProvider
implements AuthenticationProvider<Credentials> {
    private final List<AuthenticationProvider<? super Credentials>> providers = new ArrayList<AuthenticationProvider<? super Credentials>>();
    private final boolean all;

    public static CombineAuthenticationProvider all() {
        return new CombineAuthenticationProvider(true);
    }

    public static CombineAuthenticationProvider any() {
        return new CombineAuthenticationProvider(false);
    }

    private CombineAuthenticationProvider(boolean all) {
        this.all = all;
    }

    public CombineAuthenticationProvider add(AuthenticationProvider<? super Credentials> other) {
        this.providers.add(other);
        return this;
    }

    @Override
    public CompletableFuture<User> authenticate(@NotNull Credentials credentials) {
        try {
            credentials.validate(null);
        }
        catch (CredentialValidationException ex) {
            return CompletableFuture.failedFuture(ex);
        }
        if (this.providers.isEmpty()) {
            return CompletableFuture.failedFuture(new AuthenticationException("The combined providers list is empty."));
        }
        return this.iterate(0, credentials, null);
    }

    private CompletableFuture<User> iterate(int idx, Credentials credentials, User previousUser) {
        if (idx >= this.providers.size()) {
            if (!this.all) {
                return CompletableFuture.failedFuture(new AuthenticationException("No provider capable of performing this operation."));
            }
            return CompletableFuture.completedFuture(previousUser);
        }
        return ((CompletableFuture)this.providers.get(idx).authenticate(credentials).thenCompose(user -> {
            if (!this.all) {
                return CompletableFuture.completedFuture(user);
            }
            return this.iterate(idx + 1, credentials, previousUser == null ? user : previousUser.merge((User)user));
        })).exceptionallyCompose(err -> {
            if (!this.all) {
                return this.iterate(idx + 1, credentials, null);
            }
            return CompletableFuture.failedFuture(err);
        });
    }
}

