/*
 * Decompiled with CFR 0.152.
 */
package one.jpro.platform.auth.core.http.impl;

import java.io.IOException;
import java.io.InputStream;
import java.net.InetSocketAddress;
import java.net.SocketOption;
import java.net.StandardSocketOptions;
import java.net.URI;
import java.nio.channels.SelectableChannel;
import java.nio.channels.SelectionKey;
import java.nio.channels.Selector;
import java.nio.channels.ServerSocketChannel;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import javafx.application.Platform;
import javafx.stage.Stage;
import one.jpro.platform.auth.core.http.HttpOptions;
import one.jpro.platform.auth.core.http.HttpServer;
import one.jpro.platform.auth.core.http.HttpServerException;
import one.jpro.platform.auth.core.http.HttpStatus;
import one.jpro.platform.auth.core.http.impl.ConnectionEventLoop;
import one.jpro.platform.auth.core.http.impl.Handler;
import one.jpro.platform.auth.core.http.impl.Header;
import one.jpro.platform.auth.core.http.impl.Response;
import one.jpro.platform.utils.OpenLink;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class HttpServerImpl
implements HttpServer {
    private static final Logger logger = LoggerFactory.getLogger(HttpServerImpl.class);
    static final String HEADER_CONTENT_TYPE = "Content-Type";
    static final String MIME_PLAINTEXT = "text/plain";
    static final String MIME_HTML = "text/html";
    static final byte[] SPACE = " ".getBytes();
    static final byte[] CRLF = "\r\n".getBytes();
    private String uri;
    private boolean isReusePortSupported;
    private boolean isPortBound;
    @Nullable
    private final Stage stage;
    @NotNull
    private final HttpOptions options;
    private final Selector selector;
    private final AtomicBoolean stop;
    private final ServerSocketChannel serverSocketChannel;
    private final List<ConnectionEventLoop> connectionEventLoops;
    private final CompletableFuture<String> serverResponseFuture = new CompletableFuture();
    private final Thread thread;

    public HttpServerImpl(@Nullable Stage stage, @NotNull HttpOptions options) throws IOException {
        this.stage = stage;
        this.options = Objects.requireNonNull(options, "Http options cannot be null");
        Response response = new Response(HttpStatus.OK.getCode(), HttpStatus.OK.getMessage(), List.of(new Header(HEADER_CONTENT_TYPE, MIME_HTML)), this.getResourceAsBytes("default-response.html"));
        Handler handler = (request, callback) -> {
            this.uri = request.uri();
            logger.debug("***************************************************************************");
            logger.debug("Server host: {}", (Object)this.getServerHost());
            logger.debug("Server port: {}", (Object)this.getServerPort());
            logger.debug("Full requested URL: {}", (Object)this.getFullRequestedURL());
            logger.debug("Parameters: {}", this.getParameters());
            logger.debug("Request URI: {}", (Object)request.uri());
            logger.debug("Request method: {}", (Object)request.method());
            logger.debug("Request version: {}", (Object)request.version());
            logger.debug("Request headers: {}", request.headers());
            logger.debug("Response status: {}", (Object)response.status());
            logger.debug("Response body: {}", (Object)new String(response.body()));
            logger.debug("***************************************************************************");
            callback.accept(response);
            this.serverResponseFuture.complete(this.uri);
        };
        Runtime.getRuntime().addShutdownHook(new Thread(this::stop));
        this.selector = Selector.open();
        this.stop = new AtomicBoolean();
        AtomicLong connectionCounter = new AtomicLong();
        this.connectionEventLoops = new ArrayList<ConnectionEventLoop>();
        for (int i = 0; i < options.getConcurrency(); ++i) {
            this.connectionEventLoops.add(new ConnectionEventLoop(options, handler, connectionCounter, this.stop));
        }
        this.thread = new Thread(this::run, "http-server-thread");
        this.thread.setDaemon(true);
        this.serverSocketChannel = ServerSocketChannel.open();
        this.serverSocketChannel.configureBlocking(false);
        Set<SocketOption<?>> supportedOptions = this.serverSocketChannel.supportedOptions();
        if (options.isReuseAddr()) {
            if (supportedOptions.contains(StandardSocketOptions.SO_REUSEADDR)) {
                this.serverSocketChannel.setOption((SocketOption)StandardSocketOptions.SO_REUSEADDR, (Object)options.isReuseAddr());
            } else {
                logger.warn("The 'SO_REUSEADDR' option is not supported on this platform.");
            }
        }
        if (options.isReusePort()) {
            if (supportedOptions.contains(StandardSocketOptions.SO_REUSEPORT)) {
                this.serverSocketChannel.setOption((SocketOption)StandardSocketOptions.SO_REUSEPORT, (Object)options.isReusePort());
                this.isReusePortSupported = true;
            } else {
                this.isReusePortSupported = false;
                logger.warn("The 'SO_REUSEPORT' option is not supported on this platform.");
            }
        }
    }

    private byte[] getResourceAsBytes(@NotNull String name) throws IOException {
        try (InputStream is = HttpServer.class.getResourceAsStream(name);){
            if (is != null) {
                byte[] bytes = is.readAllBytes();
                String content = new String(bytes, StandardCharsets.UTF_8);
                String normalizedContent = content.replace("\r\n", "\n").replace("\r", "\n");
                byte[] byArray = normalizedContent.getBytes(StandardCharsets.UTF_8);
                return byArray;
            }
        }
        return SPACE;
    }

    @Override
    public void start() {
        if (!this.isReusePortSupported && this.isPortBound) {
            return;
        }
        try {
            InetSocketAddress address = this.options.getHost() == null ? new InetSocketAddress(this.options.getPort()) : new InetSocketAddress(this.options.getHost(), this.options.getPort());
            this.serverSocketChannel.bind(address, this.options.getAcceptLength());
            this.serverSocketChannel.register(this.selector, 16);
            this.isPortBound = true;
        }
        catch (IOException ex) {
            throw new HttpServerException(ex);
        }
        this.thread.start();
        this.connectionEventLoops.forEach(ConnectionEventLoop::start);
        logger.info("Starting server on port: {}", (Object)this.getServerPort());
    }

    private void run() {
        try {
            this.doRun();
        }
        catch (IOException ex) {
            logger.error("Error on connection termination", (Throwable)ex);
            this.stop.set(true);
        }
    }

    private void doRun() throws IOException {
        while (!this.stop.get()) {
            this.selector.select(this.options.getResolution().toMillis());
            Set<SelectionKey> selectedKeys = this.selector.selectedKeys();
            Iterator<SelectionKey> it = selectedKeys.iterator();
            while (it.hasNext()) {
                SelectionKey selKey = it.next();
                Optional<ConnectionEventLoop> leastConnections = this.leastConnections();
                if (selKey.isAcceptable() && leastConnections.isPresent()) {
                    ConnectionEventLoop connectionEventLoop = leastConnections.get();
                    connectionEventLoop.register(this.serverSocketChannel.accept());
                }
                it.remove();
            }
        }
    }

    private Optional<ConnectionEventLoop> leastConnections() {
        return this.connectionEventLoops.stream().min(Comparator.comparing(ConnectionEventLoop::numConnections));
    }

    @Override
    public void stop() {
        this.stop.set(true);
        if (this.serverSocketChannel.isOpen()) {
            try {
                this.serverSocketChannel.close();
                TimeUnit.MILLISECONDS.sleep(this.options.getResolution().toMillis());
            }
            catch (IOException | InterruptedException ex) {
                throw new HttpServerException(ex);
            }
            logger.info("Server stopped on port: {}", (Object)this.getServerPort());
        }
        if (this.selector.isOpen()) {
            try {
                for (SelectionKey key : this.selector.keys()) {
                    SelectableChannel channel = key.channel();
                    if (!channel.isOpen()) continue;
                    channel.close();
                }
                this.selector.close();
            }
            catch (IOException ex) {
                throw new HttpServerException(ex);
            }
        }
    }

    @Override
    public String getServerHost() {
        return this.options.getHost();
    }

    @Override
    public int getServerPort() {
        return this.options.getPort();
    }

    @Override
    public String getFullRequestedURL() {
        return this.uri;
    }

    @Override
    public CompletableFuture<String> openURL(@NotNull String url) {
        return ((CompletableFuture)((CompletableFuture)CompletableFuture.runAsync(this::start).thenRun(() -> OpenLink.openURL((String)URI.create(url).toString()))).thenCombine(this.serverResponseFuture, (result1, result2) -> result2)).thenApply(result -> {
            if (this.stage != null && this.stage.isShowing()) {
                Platform.runLater(() -> ((Stage)this.stage).toFront());
            }
            this.stop();
            return result;
        });
    }
}

