/*
 * Decompiled with CFR 0.152.
 */
package one.jpro.platform.auth.core.oauth2.provider;

import io.jsonwebtoken.io.Encoders;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import javafx.stage.Stage;
import one.jpro.platform.auth.core.http.HttpMethod;
import one.jpro.platform.auth.core.oauth2.OAuth2API;
import one.jpro.platform.auth.core.oauth2.OAuth2Flow;
import one.jpro.platform.auth.core.oauth2.OAuth2Options;
import one.jpro.platform.auth.core.oauth2.provider.OpenIDAuthenticationProvider;
import one.jpro.platform.auth.core.utils.AuthUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.json.JSONObject;

public class GoogleAuthenticationProvider
extends OpenIDAuthenticationProvider {
    public static final List<String> DEFAULT_SCOPES = List.of("openid", "email", "profile");

    public GoogleAuthenticationProvider(@Nullable Stage stage, @NotNull OAuth2Options options) {
        super(stage, new GoogleOAuth2API(options));
    }

    public GoogleAuthenticationProvider(@Nullable Stage stage, @NotNull String clientId, @NotNull String clientSecret) {
        super(stage, new GoogleOAuth2API(new OAuth2Options().setFlow(OAuth2Flow.AUTH_CODE).setClientId(clientId).setClientSecret(clientSecret).setSupportedScopes(DEFAULT_SCOPES).setSite("https://accounts.google.com").setTokenPath("https://oauth2.googleapis.com/token").setAuthorizationPath("/o/oauth2/v2/auth").setUserInfoPath("https://www.googleapis.com/oauth2/v1/userinfo").setJwkPath("https://www.googleapis.com/oauth2/v3/certs").setIntrospectionPath("https://oauth2.googleapis.com/tokeninfo").setRevocationPath("https://oauth2.googleapis.com/revoke").setUserInfoParams(new JSONObject().put("alt", (Object)"json"))));
    }

    public static CompletableFuture<OpenIDAuthenticationProvider> discover(@Nullable Stage stage, @NotNull OAuth2Options options) {
        String site = options.getSite() == null ? "https://accounts.google.com" : options.getSite();
        return new GoogleAuthenticationProvider(stage, new OAuth2Options(options).setSite(site).setUserInfoParams(new JSONObject().put("alt", (Object)"json"))).discover();
    }

    private static class GoogleOAuth2API
    extends OAuth2API {
        public GoogleOAuth2API(@NotNull OAuth2Options options) {
            super(options);
        }

        @Override
        public CompletableFuture<JSONObject> tokenIntrospection(String tokenType, String token) {
            boolean confidentialClient;
            JSONObject headers = new JSONObject();
            boolean bl = confidentialClient = this.options.getClientId() != null && this.options.getClientSecret() != null;
            if (confidentialClient) {
                String basic = this.options.getClientId() + ":" + this.options.getClientSecret();
                headers.put("Authorization", (Object)("Basic " + (String)Encoders.BASE64URL.encode((Object)basic.getBytes(StandardCharsets.UTF_8))));
            }
            String path = this.options.getIntrospectionPath() + "?" + tokenType + "=" + token;
            headers.put("Content-Type", (Object)"application/x-www-form-urlencoded");
            headers.put("Accept", (Object)"application/json,application/x-www-form-urlencoded;q=0.9");
            return this.fetch(HttpMethod.POST, path, headers, null).thenCompose(response -> {
                JSONObject json;
                if (response.body() == null || ((String)response.body()).isEmpty()) {
                    return CompletableFuture.failedFuture(new RuntimeException("No Body"));
                }
                if (AuthUtils.containsValue(response.headers(), "application/json")) {
                    json = new JSONObject((String)response.body());
                } else if (AuthUtils.containsValue(response.headers(), "application/x-www-form-urlencoded") || AuthUtils.containsValue(response.headers(), "text/plain")) {
                    json = AuthUtils.queryToJson((String)response.body());
                } else {
                    return CompletableFuture.failedFuture(new RuntimeException("Cannot handle accessToken type: " + String.valueOf(response.headers().allValues("Content-Type"))));
                }
                if (json == null || json.has("error")) {
                    return CompletableFuture.failedFuture(new RuntimeException(AuthUtils.extractErrorDescription(json)));
                }
                AuthUtils.processNonStandardHeaders(json, response, this.options.getScopeSeparator());
                return CompletableFuture.completedFuture(json);
            });
        }
    }
}

