/*
 * Decompiled with CFR 0.152.
 */
package one.jpro.platform.auth.routing;

import com.jpro.webapi.WebAPI;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import javafx.scene.Node;
import one.jpro.platform.auth.core.authentication.Credentials;
import one.jpro.platform.auth.core.authentication.User;
import one.jpro.platform.auth.core.oauth2.OAuth2AuthenticationProvider;
import one.jpro.platform.auth.core.oauth2.OAuth2Credentials;
import one.jpro.platform.auth.core.oauth2.provider.OpenIDAuthenticationProvider;
import one.jpro.platform.auth.routing.UserSession;
import one.jpro.platform.routing.Filter;
import one.jpro.platform.routing.LinkUtil;
import one.jpro.platform.routing.Response;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import simplefx.experimental.parts.FXFuture;

public interface AuthOAuth2Filter {
    public static Filter create(@NotNull OpenIDAuthenticationProvider openidAuthProvider, @NotNull Function<User, Response> userFunction, @NotNull Function<Throwable, Response> errorFunction) {
        OAuth2Credentials credentials = openidAuthProvider.getCredentials();
        return AuthOAuth2Filter.create((OAuth2AuthenticationProvider)openidAuthProvider, null, credentials, userFunction, errorFunction);
    }

    public static Filter create(@NotNull OpenIDAuthenticationProvider openidAuthProvider, @NotNull UserSession userSession, @NotNull Function<User, Response> userFunction, @NotNull Function<Throwable, Response> errorFunction) {
        Objects.requireNonNull(userSession, "userSession can not be null");
        OAuth2Credentials credentials = openidAuthProvider.getCredentials();
        return AuthOAuth2Filter.create((OAuth2AuthenticationProvider)openidAuthProvider, userSession, credentials, userFunction, errorFunction);
    }

    public static Filter create(@NotNull OAuth2AuthenticationProvider authProvider, @Nullable UserSession userSession, @NotNull OAuth2Credentials credentials, @NotNull Function<User, Response> userFunction, @NotNull Function<Throwable, Response> errorFunction) {
        Objects.requireNonNull(authProvider, "OAuth2 authentication provider can not be null");
        Objects.requireNonNull(credentials, "OAuth2 credentials can not be null");
        Objects.requireNonNull(userFunction, "User function can not be null");
        Objects.requireNonNull(errorFunction, "Error function cannot be null");
        return route -> request -> {
            if (request.getPath().equals(credentials.getRedirectUri())) {
                return new Response(FXFuture.fromJava((CompletableFuture)authProvider.authenticate((Credentials)credentials)).flatMap(r -> {
                    if (userSession != null) {
                        userSession.setUser((User)r);
                    }
                    return ((Response)userFunction.apply((User)r)).future();
                }).flatExceptionally(r -> ((Response)errorFunction.apply((Throwable)r)).future()));
            }
            return route.apply(request);
        };
    }

    public static void authorize(@NotNull Node node, @NotNull OAuth2AuthenticationProvider authProvider, @NotNull OAuth2Credentials credentials) {
        Objects.requireNonNull(node, "Node can not be null");
        Objects.requireNonNull(authProvider, "OAuth2 authentication provider can not be null");
        FXFuture.fromJava((CompletableFuture)authProvider.authorizeUrl(credentials)).map(url -> {
            if (!WebAPI.isBrowser()) {
                LinkUtil.getSessionManager((Node)node).gotoURL(url);
            }
            return url;
        });
    }

    public static void authorize(@NotNull Node node, @NotNull OpenIDAuthenticationProvider openidAuthProvider) {
        Objects.requireNonNull(node, "Node can not be null");
        Objects.requireNonNull(openidAuthProvider, "OpenID authentication provider can not be null");
        FXFuture.fromJava((CompletableFuture)openidAuthProvider.authorizeUrl()).map(url -> {
            if (!WebAPI.isBrowser()) {
                LinkUtil.getSessionManager((Node)node).gotoURL(url);
            }
            return url;
        });
    }
}

