/*
 * Decompiled with CFR 0.152.
 */
package one.jpro.platform.auth.routing;

import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import javafx.scene.Node;
import one.jpro.platform.auth.core.authentication.User;
import one.jpro.platform.auth.core.basic.UsernamePasswordCredentials;
import one.jpro.platform.auth.core.basic.provider.BasicAuthenticationProvider;
import one.jpro.platform.routing.Filter;
import one.jpro.platform.routing.LinkUtil;
import one.jpro.platform.routing.Response;
import org.jetbrains.annotations.NotNull;
import simplefx.experimental.parts.FXFuture;

public interface AuthBasicFilter {
    public static Filter create(@NotNull BasicAuthenticationProvider authProvider, @NotNull UsernamePasswordCredentials credentials, @NotNull Function<User, Response> userFunction, @NotNull Function<Throwable, Response> errorFunction) {
        Objects.requireNonNull(authProvider, "Authentication provider cannot be null");
        return route -> request -> {
            if (request.getPath().equals(authProvider.getAuthorizationPath())) {
                return new Response(FXFuture.fromJava((CompletableFuture)authProvider.authenticate(credentials)).flatMap(user -> ((Response)userFunction.apply((User)user)).future()).flatExceptionally(error -> ((Response)errorFunction.apply((Throwable)error)).future()));
            }
            return route.apply(request);
        };
    }

    public static void authorize(@NotNull Node node, @NotNull BasicAuthenticationProvider basicAuthProvider) {
        Objects.requireNonNull(node, "Node can not be null");
        Objects.requireNonNull(basicAuthProvider, "Authentication provider can not be null");
        LinkUtil.getSessionManager((Node)node).gotoURL(basicAuthProvider.getAuthorizationPath());
    }
}

