/*
 * Decompiled with CFR 0.152.
 */
package one.jpro.platform.auth.routing;

import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import one.jpro.platform.auth.core.authentication.User;
import one.jpro.platform.auth.core.jwt.JWTAuthenticationProvider;
import one.jpro.platform.routing.Filter;
import one.jpro.platform.routing.Response;
import org.jetbrains.annotations.NotNull;
import org.json.JSONObject;
import simplefx.experimental.parts.FXFuture;

public interface AuthJwtFilter {
    public static Filter create(@NotNull JWTAuthenticationProvider authProvider, @NotNull JSONObject credentials, @NotNull String authPath, @NotNull String tokenPath, @NotNull Function<User, Response> userFunction, @NotNull Function<Throwable, Response> errorFunction) {
        Objects.requireNonNull(authProvider, "Authentication provider cannot be null");
        Objects.requireNonNull(credentials, "Credentials cannot be null");
        Objects.requireNonNull(authPath, "Authentication path cannot be null");
        Objects.requireNonNull(tokenPath, "Token path cannot be null");
        Objects.requireNonNull(userFunction, "User function cannot be null");
        Objects.requireNonNull(errorFunction, "Error function cannot be null");
        return route -> request -> {
            if (request.getPath().equals(authPath)) {
                return new Response(FXFuture.fromJava((CompletableFuture)authProvider.token(tokenPath, credentials).thenCompose(arg_0 -> ((JWTAuthenticationProvider)authProvider).authenticate(arg_0))).flatMap(user -> ((Response)userFunction.apply((User)user)).future()).flatExceptionally(error -> ((Response)errorFunction.apply((Throwable)error)).future()));
            }
            return route.apply(request);
        };
    }
}

