/*
 * Decompiled with CFR 0.152.
 */
package one.jpro.platform.file.picker;

import java.io.File;
import java.util.List;
import java.util.Optional;
import java.util.function.Consumer;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.property.SimpleStringProperty;
import javafx.beans.property.StringProperty;
import javafx.beans.value.ObservableValue;
import javafx.collections.ListChangeListener;
import javafx.collections.WeakListChangeListener;
import javafx.scene.Node;
import javafx.scene.control.SelectionMode;
import javafx.scene.input.MouseEvent;
import javafx.stage.FileChooser;
import javafx.stage.Window;
import one.jpro.platform.file.ExtensionFilter;
import one.jpro.platform.file.FileSource;
import one.jpro.platform.file.NativeFileSource;
import one.jpro.platform.file.picker.BaseFileOpenPicker;

public class NativeFileOpenPicker
extends BaseFileOpenPicker {
    private final FileChooser fileChooser = new FileChooser();
    private List<NativeFileSource> nativeFileSources = List.of();
    private final ListChangeListener<ExtensionFilter> extensionFiltersListChangeListener = change -> {
        while (change.next()) {
            if (change.wasAdded()) {
                for (ExtensionFilter extensionFilter : change.getAddedSubList()) {
                    this.fileChooser.getExtensionFilters().add((Object)new FileChooser.ExtensionFilter(extensionFilter.description(), extensionFilter.extensions().stream().map(ext -> "*" + ext).toList()));
                }
                continue;
            }
            if (!change.wasRemoved()) continue;
            for (ExtensionFilter extensionFilter : change.getRemoved()) {
                this.fileChooser.getExtensionFilters().removeIf(filter -> filter.getDescription().equals(extensionFilter.description()));
            }
        }
    };

    public NativeFileOpenPicker(Node node) {
        super(node);
        this.getExtensionFilters().addListener((ListChangeListener)new WeakListChangeListener(this.extensionFiltersListChangeListener));
        node.addEventHandler(MouseEvent.MOUSE_CLICKED, actionEvent -> {
            Window window = node.getScene().getWindow();
            if (this.getSelectionMode() == SelectionMode.MULTIPLE) {
                List files = this.fileChooser.showOpenMultipleDialog(window);
                if (files != null && !files.isEmpty()) {
                    this.nativeFileSources = files.stream().map(NativeFileSource::new).toList();
                    Consumer<List<? extends FileSource>> onFilesSelectedConsumer = this.getOnFilesSelected();
                    if (onFilesSelectedConsumer != null) {
                        onFilesSelectedConsumer.accept(this.nativeFileSources);
                    }
                }
            } else {
                File file = this.fileChooser.showOpenDialog(window);
                if (file != null) {
                    this.nativeFileSources = List.of(new NativeFileSource(file));
                    Consumer<List<? extends FileSource>> onFilesSelectedConsumer = this.getOnFilesSelected();
                    if (onFilesSelectedConsumer != null) {
                        onFilesSelectedConsumer.accept(this.nativeFileSources);
                    }
                }
            }
        });
    }

    @Override
    public final String getTitle() {
        return this.fileChooser.getTitle();
    }

    @Override
    public final void setTitle(String value) {
        this.fileChooser.setTitle(value);
    }

    @Override
    public final StringProperty titleProperty() {
        return this.fileChooser.titleProperty();
    }

    @Override
    public final StringProperty initialFileNameProperty() {
        if (this.initialFileName == null) {
            this.initialFileName = new SimpleStringProperty((Object)this, "initialFileName");
            this.fileChooser.initialFileNameProperty().bind((ObservableValue)this.initialFileName);
        }
        return this.initialFileName;
    }

    @Override
    public final File getInitialDirectory() {
        return this.fileChooser.getInitialDirectory();
    }

    @Override
    public final void setInitialDirectory(File value) {
        this.fileChooser.setInitialDirectory(value);
    }

    @Override
    public final ObjectProperty<File> initialDirectoryProperty() {
        return this.fileChooser.initialDirectoryProperty();
    }

    @Override
    public final ObjectProperty<ExtensionFilter> selectedExtensionFilterProperty() {
        if (this.selectedExtensionFilter == null) {
            this.selectedExtensionFilter = new SimpleObjectProperty<ExtensionFilter>((Object)this, "selectedExtensionFilter"){

                protected void invalidated() {
                    ExtensionFilter selectedExtensionFilter = (ExtensionFilter)this.get();
                    if (selectedExtensionFilter != null) {
                        Optional<FileChooser.ExtensionFilter> optionalExtensionFilter = NativeFileOpenPicker.this.fileChooser.getExtensionFilters().stream().filter(extensionFilter -> extensionFilter.getDescription().equals(selectedExtensionFilter.description())).findFirst();
                        if (optionalExtensionFilter.isPresent()) {
                            NativeFileOpenPicker.this.fileChooser.setSelectedExtensionFilter(optionalExtensionFilter.get());
                        } else {
                            NativeFileOpenPicker.this.getExtensionFilters().add((Object)selectedExtensionFilter);
                            NativeFileOpenPicker.this.fileChooser.getExtensionFilters().stream().filter(extensionFilter -> extensionFilter.getDescription().equals(selectedExtensionFilter.description())).findFirst().ifPresent(arg_0 -> ((FileChooser)NativeFileOpenPicker.this.fileChooser).setSelectedExtensionFilter(arg_0));
                        }
                    } else {
                        NativeFileOpenPicker.this.fileChooser.setSelectedExtensionFilter(null);
                    }
                }
            };
        }
        return this.selectedExtensionFilter;
    }

    @Override
    public final ObjectProperty<SelectionMode> selectionModeProperty() {
        if (this.selectionMode == null) {
            this.selectionMode = new SimpleObjectProperty((Object)this, "selectionMode", (Object)SelectionMode.SINGLE);
        }
        return this.selectionMode;
    }
}

