/*
 * Decompiled with CFR 0.152.
 */
package one.jpro.platform.file.picker;

import java.io.File;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.property.SimpleStringProperty;
import javafx.beans.property.StringProperty;
import javafx.beans.value.ObservableValue;
import javafx.collections.ListChangeListener;
import javafx.collections.WeakListChangeListener;
import javafx.scene.Node;
import javafx.scene.Scene;
import javafx.stage.FileChooser;
import javafx.stage.Window;
import one.jpro.platform.file.ExtensionFilter;
import one.jpro.platform.file.picker.BaseFileSavePicker;

public class NativeFileSavePicker
extends BaseFileSavePicker {
    private final FileChooser fileChooser = new FileChooser();
    private final ListChangeListener<ExtensionFilter> extensionFiltersListChangeListener = change -> {
        while (change.next()) {
            if (change.wasAdded()) {
                for (ExtensionFilter extensionFilter : change.getAddedSubList()) {
                    this.fileChooser.getExtensionFilters().add((Object)new FileChooser.ExtensionFilter(extensionFilter.description(), extensionFilter.extensions().stream().map(ext -> "*" + ext).toList()));
                }
                continue;
            }
            if (!change.wasRemoved()) continue;
            for (ExtensionFilter extensionFilter : change.getRemoved()) {
                this.fileChooser.getExtensionFilters().removeIf(filter -> filter.getDescription().equals(extensionFilter.description()));
            }
        }
    };

    public NativeFileSavePicker(Node node) {
        super(node);
        this.getExtensionFilters().addListener((ListChangeListener)new WeakListChangeListener(this.extensionFiltersListChangeListener));
    }

    @Override
    public final String getTitle() {
        return this.fileChooser.getTitle();
    }

    @Override
    public final void setTitle(String value) {
        this.fileChooser.setTitle(value);
    }

    @Override
    public final StringProperty titleProperty() {
        return this.fileChooser.titleProperty();
    }

    @Override
    public final StringProperty initialFileNameProperty() {
        if (this.initialFileName == null) {
            this.initialFileName = new SimpleStringProperty((Object)this, "initialFileName");
            this.fileChooser.initialFileNameProperty().bind((ObservableValue)this.initialFileName);
        }
        return this.initialFileName;
    }

    @Override
    public final File getInitialDirectory() {
        return this.fileChooser.getInitialDirectory();
    }

    @Override
    public final void setInitialDirectory(File value) {
        this.fileChooser.setInitialDirectory(value);
    }

    @Override
    public final ObjectProperty<File> initialDirectoryProperty() {
        return this.fileChooser.initialDirectoryProperty();
    }

    @Override
    public final ObjectProperty<ExtensionFilter> selectedExtensionFilterProperty() {
        if (this.selectedExtensionFilter == null) {
            this.selectedExtensionFilter = new SimpleObjectProperty<ExtensionFilter>((Object)this, "selectedExtensionFilter"){

                protected void invalidated() {
                    ExtensionFilter selectedExtensionFilter = (ExtensionFilter)this.get();
                    if (selectedExtensionFilter != null) {
                        Optional<FileChooser.ExtensionFilter> optionalExtensionFilter = NativeFileSavePicker.this.fileChooser.getExtensionFilters().stream().filter(extensionFilter -> extensionFilter.getDescription().equals(selectedExtensionFilter.description())).findFirst();
                        if (optionalExtensionFilter.isPresent()) {
                            NativeFileSavePicker.this.fileChooser.setSelectedExtensionFilter(optionalExtensionFilter.get());
                        } else {
                            NativeFileSavePicker.this.getExtensionFilters().add((Object)selectedExtensionFilter);
                            NativeFileSavePicker.this.fileChooser.getExtensionFilters().stream().filter(extensionFilter -> extensionFilter.getDescription().equals(selectedExtensionFilter.description())).findFirst().ifPresent(arg_0 -> ((FileChooser)NativeFileSavePicker.this.fileChooser).setSelectedExtensionFilter(arg_0));
                        }
                    } else {
                        NativeFileSavePicker.this.fileChooser.setSelectedExtensionFilter(null);
                    }
                }
            };
        }
        return this.selectedExtensionFilter;
    }

    @Override
    final void showDialog() {
        Function<File, CompletableFuture<Void>> onFileSelected;
        this.fileChooser.setTitle("Save file as...");
        Scene scene = this.getNode().getScene();
        if (scene == null) {
            throw new IllegalStateException("Node must be attached to a scene");
        }
        Window window = scene.getWindow();
        if (window == null) {
            throw new IllegalStateException("Scene must be attached to a stage");
        }
        File saveToFile = this.fileChooser.showSaveDialog(window);
        if (saveToFile != null && (onFileSelected = this.getOnFileSelected()) != null) {
            onFileSelected.apply(saveToFile);
        }
    }
}

