/*
 * Decompiled with CFR 0.152.
 */
package one.jpro.platform.file.dropper;

import com.sun.javafx.event.EventHandlerManager;
import java.io.File;
import java.util.List;
import java.util.Objects;
import java.util.function.Consumer;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.event.EventDispatchChain;
import javafx.event.EventDispatcher;
import javafx.event.EventHandler;
import javafx.scene.Node;
import javafx.scene.control.SelectionMode;
import one.jpro.platform.file.ExtensionFilter;
import one.jpro.platform.file.FileSource;
import one.jpro.platform.file.dropper.FileDropper;
import one.jpro.platform.file.event.FileDragEvent;

abstract class BaseFileDropper
implements FileDropper {
    private final Node node;
    ObjectProperty<ExtensionFilter> extensionFilter;
    ObjectProperty<SelectionMode> selectionMode;
    private ObjectProperty<EventHandler<FileDragEvent>> onDragEntered;
    private ObjectProperty<EventHandler<FileDragEvent>> onDragExited;
    ObjectProperty<Consumer<List<? extends FileSource>>> onFilesSelected;
    private final EventHandlerManager eventHandlerManager = new EventHandlerManager((Object)this);

    public BaseFileDropper(Node node) {
        this.node = Objects.requireNonNull(node, "node must not be null");
    }

    @Override
    public Node getNode() {
        return this.node;
    }

    @Override
    public final ExtensionFilter getExtensionFilter() {
        return this.extensionFilter != null ? (ExtensionFilter)this.extensionFilter.get() : null;
    }

    @Override
    public final void setExtensionFilter(ExtensionFilter filter) {
        this.extensionFilterProperty().setValue((Object)filter);
    }

    @Override
    public final ObjectProperty<ExtensionFilter> extensionFilterProperty() {
        if (this.extensionFilter == null) {
            this.extensionFilter = new SimpleObjectProperty((Object)this, "extensionFilter");
        }
        return this.extensionFilter;
    }

    @Override
    public final SelectionMode getSelectionMode() {
        return this.selectionMode == null ? SelectionMode.SINGLE : (SelectionMode)this.selectionMode.get();
    }

    @Override
    public final void setSelectionMode(SelectionMode value) {
        this.selectionModeProperty().setValue((Object)value);
    }

    @Override
    public ObjectProperty<SelectionMode> selectionModeProperty() {
        if (this.selectionMode == null) {
            this.selectionMode = new SimpleObjectProperty((Object)this, "selectionMode", (Object)SelectionMode.SINGLE);
        }
        return this.selectionMode;
    }

    @Override
    public final EventHandler<FileDragEvent> getOnDragEntered() {
        return this.onDragEntered == null ? null : (EventHandler)this.onDragEntered.get();
    }

    @Override
    public final void setOnDragEntered(EventHandler<FileDragEvent> value) {
        this.onDragEnteredProperty().setValue(value);
    }

    @Override
    public final ObjectProperty<EventHandler<FileDragEvent>> onDragEnteredProperty() {
        if (this.onDragEntered == null) {
            this.onDragEntered = new SimpleObjectProperty<EventHandler<FileDragEvent>>((Object)this, "onDragEntered"){

                protected void invalidated() {
                    BaseFileDropper.this.eventHandlerManager.setEventHandler(FileDragEvent.FILE_DRAG_ENTERED, (EventHandler)this.get());
                }
            };
        }
        return this.onDragEntered;
    }

    @Override
    public final EventHandler<FileDragEvent> getOnDragExited() {
        return this.onDragExited == null ? null : (EventHandler)this.onDragExited.get();
    }

    @Override
    public final void setOnDragExited(EventHandler<FileDragEvent> value) {
        this.onDragExitedProperty().setValue(value);
    }

    @Override
    public final ObjectProperty<EventHandler<FileDragEvent>> onDragExitedProperty() {
        if (this.onDragExited == null) {
            this.onDragExited = new SimpleObjectProperty<EventHandler<FileDragEvent>>((Object)this, "onDragExited"){

                protected void invalidated() {
                    BaseFileDropper.this.eventHandlerManager.setEventHandler(FileDragEvent.FILE_DRAG_EXITED, (EventHandler)this.get());
                }
            };
        }
        return this.onDragExited;
    }

    @Override
    public Consumer<List<? extends FileSource>> getOnFilesSelected() {
        return this.onFilesSelected == null ? null : (Consumer)this.onFilesSelected.get();
    }

    @Override
    public void setOnFilesSelected(Consumer<List<? extends FileSource>> value) {
        this.onFilesSelectedProperty().setValue(value);
    }

    @Override
    public ObjectProperty<Consumer<List<? extends FileSource>>> onFilesSelectedProperty() {
        if (this.onFilesSelected == null) {
            this.onFilesSelected = new SimpleObjectProperty((Object)this, "onFilesSelected");
        }
        return this.onFilesSelected;
    }

    public EventDispatchChain buildEventDispatchChain(EventDispatchChain tail) {
        return tail.prepend((EventDispatcher)this.eventHandlerManager);
    }

    boolean hasSupportedExtension(List<File> files) {
        ExtensionFilter extensionFilter = this.getExtensionFilter();
        return extensionFilter == null || files.stream().anyMatch(file -> extensionFilter.extensions().stream().anyMatch(extension -> file.getName().endsWith((String)extension)));
    }
}

