/*
 * Decompiled with CFR 0.152.
 */
package one.jpro.platform.file.event;

import java.io.File;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javafx.scene.input.DataFormat;
import one.jpro.platform.file.FileSource;

public class DataTransfer {
    public static final DataFormat FILE = new DataFormat(new String[]{"application/x-java-file"});
    public static final DataFormat FILES = new DataFormat(new String[]{"application/x-java-files"});
    public static final DataFormat FILE_SOURCES = new DataFormat(new String[]{"application/x-java-file-source-list"});
    public static final DataFormat MIME_TYPES = new DataFormat(new String[]{"application/x-java-mime-type-list"});
    private final Map<DataFormat, Object> data = new HashMap<DataFormat, Object>();

    public final Object getData(DataFormat format) {
        return this.data.get(format);
    }

    public final void putData(DataFormat format, Object value) {
        this.data.put(format, value);
    }

    public final void setData(Map<DataFormat, Object> map) {
        this.data.putAll(map);
    }

    public final void clearData() {
        this.data.clear();
    }

    public final boolean hasData(DataFormat format) {
        return this.data.containsKey(format);
    }

    public final boolean hasFile() {
        return this.hasData(FILE);
    }

    public final File getFile() {
        return (File)this.data.get(FILE);
    }

    public final boolean hasFiles() {
        return this.hasData(FILES);
    }

    public final List<File> getFiles() {
        return (List)this.data.get(FILES);
    }

    public final boolean hasFileSources() {
        return this.hasData(FILE_SOURCES);
    }

    public final List<FileSource> getFileSources() {
        return (List)this.data.get(FILE_SOURCES);
    }

    public final boolean hasMimeTypes() {
        return this.hasData(MIME_TYPES);
    }

    public final List<String> getMimeTypes() {
        return (List)this.data.get(MIME_TYPES);
    }
}

