/*
 * Decompiled with CFR 0.152.
 */
package one.jpro.platform.file.picker;

import com.jpro.webapi.WebAPI;
import java.util.Objects;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.property.StringProperty;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.WeakChangeListener;
import javafx.collections.FXCollections;
import javafx.collections.ListChangeListener;
import javafx.collections.ObservableList;
import javafx.scene.Node;
import javafx.stage.FileChooser;
import one.jpro.platform.file.ExtensionFilter;
import one.jpro.platform.file.picker.FilePicker;
import org.jetbrains.annotations.NotNull;

abstract class BaseFilePicker
implements FilePicker {
    private final Node node;
    private boolean updatingFromFileChooser = false;
    private boolean updatingFromProperty = false;
    StringProperty initialFileName;
    private final ObservableList<ExtensionFilter> extensionFilters = FXCollections.observableArrayList();
    ObjectProperty<ExtensionFilter> selectedExtensionFilter;

    BaseFilePicker(Node node) {
        this.node = Objects.requireNonNull(node, "node must not be null");
    }

    @Override
    public final Node getNode() {
        return this.node;
    }

    @Override
    public final String getInitialFileName() {
        return this.initialFileName == null ? null : (String)this.initialFileName.get();
    }

    @Override
    public final void setInitialFileName(String value) {
        this.initialFileNameProperty().setValue(value);
    }

    @Override
    public final ObservableList<ExtensionFilter> getExtensionFilters() {
        return this.extensionFilters;
    }

    @Override
    public final ExtensionFilter getSelectedExtensionFilter() {
        return this.selectedExtensionFilter != null ? (ExtensionFilter)this.selectedExtensionFilter.get() : null;
    }

    @Override
    public final void setSelectedExtensionFilter(ExtensionFilter filter) {
        this.selectedExtensionFilterProperty().setValue((Object)filter);
    }

    @Override
    public final ObjectProperty<ExtensionFilter> selectedExtensionFilterProperty() {
        if (this.selectedExtensionFilter == null) {
            this.selectedExtensionFilter = new SimpleObjectProperty((Object)this, "selectedExtensionFilter");
        }
        return this.selectedExtensionFilter;
    }

    final ExtensionFilter findSelectedFilter() {
        ExtensionFilter selectedFilter = this.getSelectedExtensionFilter();
        if (selectedFilter == null || !this.extensionFilters.contains((Object)selectedFilter)) {
            return this.extensionFilters.isEmpty() ? null : (ExtensionFilter)this.extensionFilters.get(0);
        }
        return selectedFilter;
    }

    final void synchronizeSelectedExtensionFilter(FileChooser fileChooser) {
        fileChooser.selectedExtensionFilterProperty().addListener((ChangeListener)new WeakChangeListener(this.getNativeSelectedExtensionFilterChangeListener()));
        this.selectedExtensionFilterProperty().addListener((ChangeListener)new WeakChangeListener(this.getSelectedExtensionFilterChangeListener(fileChooser)));
    }

    @NotNull
    private ChangeListener<FileChooser.ExtensionFilter> getNativeSelectedExtensionFilterChangeListener() {
        return (observable, oldFilter, newFilter) -> {
            if (this.updatingFromProperty) {
                return;
            }
            this.updatingFromFileChooser = true;
            try {
                ExtensionFilter extensionFilter = null;
                if (newFilter != null) {
                    for (ExtensionFilter ef : this.extensionFilters) {
                        if (!newFilter.getDescription().equals(ef.description())) continue;
                        extensionFilter = ef;
                        break;
                    }
                }
                this.setSelectedExtensionFilter(extensionFilter);
            }
            finally {
                this.updatingFromFileChooser = false;
            }
        };
    }

    @NotNull
    private ChangeListener<ExtensionFilter> getSelectedExtensionFilterChangeListener(FileChooser fileChooser) {
        return (observable, oldFilter, newFilter) -> {
            if (this.updatingFromFileChooser) {
                return;
            }
            this.updatingFromProperty = true;
            try {
                FileChooser.ExtensionFilter extensionFilter = null;
                if (newFilter != null) {
                    for (FileChooser.ExtensionFilter ef : fileChooser.getExtensionFilters()) {
                        if (!newFilter.description().equals(ef.getDescription())) continue;
                        extensionFilter = ef;
                        break;
                    }
                }
                fileChooser.setSelectedExtensionFilter(extensionFilter);
            }
            finally {
                this.updatingFromProperty = false;
            }
        };
    }

    @NotNull
    final ListChangeListener<ExtensionFilter> getNativeExtensionFilterListChangeListener(FileChooser fileChooser) {
        return change -> {
            while (change.next()) {
                if (change.wasAdded()) {
                    for (ExtensionFilter extensionFilter : change.getAddedSubList()) {
                        fileChooser.getExtensionFilters().add((Object)ExtensionFilter.toJavaFXExtensionFilter(extensionFilter));
                    }
                    continue;
                }
                if (!change.wasRemoved()) continue;
                for (ExtensionFilter extensionFilter : change.getRemoved()) {
                    fileChooser.getExtensionFilters().removeIf(filter -> filter.getDescription().equals(extensionFilter.description()));
                }
            }
        };
    }

    @NotNull
    final ListChangeListener<ExtensionFilter> getWebExtensionFilterListChangeListener(WebAPI.MultiFileUploader multiFileUploader) {
        return change -> {
            while (change.next()) {
                if (change.wasAdded()) {
                    for (ExtensionFilter extensionFilter : change.getAddedSubList()) {
                        extensionFilter.extensions().forEach(arg_0 -> multiFileUploader.supportedExtensions().add(arg_0));
                    }
                    continue;
                }
                if (!change.wasRemoved()) continue;
                for (ExtensionFilter extensionFilter : change.getRemoved()) {
                    extensionFilter.extensions().forEach(arg_0 -> multiFileUploader.supportedExtensions().remove(arg_0));
                }
            }
        };
    }
}

