/*
 * Decompiled with CFR 0.152.
 */
package one.jpro.platform.file.picker;

import java.io.File;
import java.util.List;
import java.util.function.Consumer;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.property.SimpleStringProperty;
import javafx.beans.property.StringProperty;
import javafx.beans.value.ObservableValue;
import javafx.collections.ListChangeListener;
import javafx.collections.WeakListChangeListener;
import javafx.scene.Node;
import javafx.scene.control.SelectionMode;
import javafx.scene.input.MouseEvent;
import javafx.stage.FileChooser;
import javafx.stage.Window;
import one.jpro.platform.file.FileSource;
import one.jpro.platform.file.NativeFileSource;
import one.jpro.platform.file.picker.BaseFileOpenPicker;
import one.jpro.platform.file.util.NodeUtils;

public class NativeFileOpenPicker
extends BaseFileOpenPicker {
    private final FileChooser fileChooser;
    private List<NativeFileSource> nativeFileSources = List.of();

    public NativeFileOpenPicker(Node node) {
        super(node);
        this.fileChooser = new FileChooser();
        this.synchronizeSelectedExtensionFilter(this.fileChooser);
        this.getExtensionFilters().addListener((ListChangeListener)new WeakListChangeListener(this.getNativeExtensionFilterListChangeListener(this.fileChooser)));
        NodeUtils.addEventHandler(node, MouseEvent.MOUSE_CLICKED, actionEvent -> {
            Window window = node.getScene().getWindow();
            if (this.getSelectionMode() == SelectionMode.MULTIPLE) {
                List files = this.fileChooser.showOpenMultipleDialog(window);
                if (files != null && !files.isEmpty()) {
                    this.nativeFileSources = files.stream().map(NativeFileSource::new).toList();
                    Consumer<List<? extends FileSource>> onFilesSelectedConsumer = this.getOnFilesSelected();
                    if (onFilesSelectedConsumer != null) {
                        onFilesSelectedConsumer.accept(this.nativeFileSources);
                    }
                }
            } else {
                File file = this.fileChooser.showOpenDialog(window);
                if (file != null) {
                    this.nativeFileSources = List.of(new NativeFileSource(file));
                    Consumer<List<? extends FileSource>> onFilesSelectedConsumer = this.getOnFilesSelected();
                    if (onFilesSelectedConsumer != null) {
                        onFilesSelectedConsumer.accept(this.nativeFileSources);
                    }
                }
            }
        });
    }

    @Override
    public final String getTitle() {
        return this.fileChooser.getTitle();
    }

    @Override
    public final void setTitle(String value) {
        this.fileChooser.setTitle(value);
    }

    @Override
    public final StringProperty titleProperty() {
        return this.fileChooser.titleProperty();
    }

    @Override
    public final StringProperty initialFileNameProperty() {
        if (this.initialFileName == null) {
            this.initialFileName = new SimpleStringProperty((Object)this, "initialFileName");
            this.fileChooser.initialFileNameProperty().bind((ObservableValue)this.initialFileName);
        }
        return this.initialFileName;
    }

    @Override
    public final File getInitialDirectory() {
        return this.fileChooser.getInitialDirectory();
    }

    @Override
    public final void setInitialDirectory(File value) {
        this.fileChooser.setInitialDirectory(value);
    }

    @Override
    public final ObjectProperty<File> initialDirectoryProperty() {
        return this.fileChooser.initialDirectoryProperty();
    }

    @Override
    public final ObjectProperty<SelectionMode> selectionModeProperty() {
        if (this.selectionMode == null) {
            this.selectionMode = new SimpleObjectProperty((Object)this, "selectionMode", (Object)SelectionMode.SINGLE);
        }
        return this.selectionMode;
    }
}

