/*
 * Decompiled with CFR 0.152.
 */
package one.jpro.platform.file.picker;

import java.io.File;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleStringProperty;
import javafx.beans.property.StringProperty;
import javafx.beans.value.ObservableValue;
import javafx.collections.ListChangeListener;
import javafx.collections.WeakListChangeListener;
import javafx.scene.Node;
import javafx.scene.Scene;
import javafx.stage.FileChooser;
import javafx.stage.Window;
import one.jpro.platform.file.picker.BaseFileSavePicker;

public class NativeFileSavePicker
extends BaseFileSavePicker {
    private final FileChooser fileChooser = new FileChooser();

    public NativeFileSavePicker(Node node) {
        super(node);
        this.synchronizeSelectedExtensionFilter(this.fileChooser);
        this.getExtensionFilters().addListener((ListChangeListener)new WeakListChangeListener(this.getNativeExtensionFilterListChangeListener(this.fileChooser)));
    }

    @Override
    public final String getTitle() {
        return this.fileChooser.getTitle();
    }

    @Override
    public final void setTitle(String value) {
        this.fileChooser.setTitle(value);
    }

    @Override
    public final StringProperty titleProperty() {
        return this.fileChooser.titleProperty();
    }

    @Override
    public final StringProperty initialFileNameProperty() {
        if (this.initialFileName == null) {
            this.initialFileName = new SimpleStringProperty((Object)this, "initialFileName");
            this.fileChooser.initialFileNameProperty().bind((ObservableValue)this.initialFileName);
        }
        return this.initialFileName;
    }

    @Override
    public final File getInitialDirectory() {
        return this.fileChooser.getInitialDirectory();
    }

    @Override
    public final void setInitialDirectory(File value) {
        this.fileChooser.setInitialDirectory(value);
    }

    @Override
    public final ObjectProperty<File> initialDirectoryProperty() {
        return this.fileChooser.initialDirectoryProperty();
    }

    @Override
    final void showDialog() {
        Function<File, CompletableFuture<Void>> onFileSelected;
        this.fileChooser.setTitle("Save file as...");
        Scene scene = this.getNode().getScene();
        if (scene == null) {
            throw new IllegalStateException("Node must be attached to a scene");
        }
        Window window = scene.getWindow();
        if (window == null) {
            throw new IllegalStateException("Scene must be attached to a stage");
        }
        File saveToFile = this.fileChooser.showSaveDialog(window);
        if (saveToFile != null && (onFileSelected = this.getOnFileSelected()) != null) {
            onFileSelected.apply(saveToFile);
        }
    }
}

