/*
 * Decompiled with CFR 0.152.
 */
package one.jpro.platform.file.picker;

import com.jpro.webapi.WebAPI;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.property.SimpleStringProperty;
import javafx.beans.property.StringProperty;
import javafx.collections.ListChangeListener;
import javafx.collections.WeakListChangeListener;
import javafx.scene.Node;
import javafx.scene.control.SelectionMode;
import one.jpro.platform.file.FileSource;
import one.jpro.platform.file.WebFileSource;
import one.jpro.platform.file.picker.BaseFileOpenPicker;
import one.jpro.platform.file.util.NodeUtils;

public class WebFileOpenPicker
extends BaseFileOpenPicker {
    private final WebAPI.MultiFileUploader multiFileUploader;
    private List<WebFileSource> webFileSources = List.of();
    private StringProperty title;
    private ObjectProperty<File> initialDirectory;

    public WebFileOpenPicker(Node node) {
        super(node);
        this.multiFileUploader = NodeUtils.getPropertyValue(node, NodeUtils.MULTI_FILE_UPLOADER_KEY, WebAPI.makeMultiFileUploadNodeStatic((Node)node));
        this.multiFileUploader.setSelectFileOnClick(Boolean.valueOf(true));
        this.getExtensionFilters().addListener((ListChangeListener)new WeakListChangeListener(this.getWebExtensionFilterListChangeListener(this.multiFileUploader)));
    }

    @Override
    public final String getTitle() {
        return this.title != null ? (String)this.title.get() : null;
    }

    @Override
    public final void setTitle(String value) {
        this.titleProperty().set((Object)value);
    }

    @Override
    public final StringProperty titleProperty() {
        if (this.title == null) {
            this.title = new SimpleStringProperty((Object)this, "title");
        }
        return this.title;
    }

    @Override
    public final StringProperty initialFileNameProperty() {
        if (this.initialFileName == null) {
            this.initialFileName = new SimpleStringProperty((Object)this, "initialFileName");
        }
        return this.initialFileName;
    }

    @Override
    public final File getInitialDirectory() {
        return this.initialDirectory != null ? (File)this.initialDirectory.get() : null;
    }

    @Override
    public final void setInitialDirectory(File value) {
        this.initialDirectoryProperty().set((Object)value);
    }

    @Override
    public final ObjectProperty<File> initialDirectoryProperty() {
        if (this.initialDirectory == null) {
            this.initialDirectory = new SimpleObjectProperty((Object)this, "initialDirectory");
        }
        return this.initialDirectory;
    }

    @Override
    public final ObjectProperty<SelectionMode> selectionModeProperty() {
        if (this.selectionMode == null) {
            this.selectionMode = new SimpleObjectProperty<SelectionMode>((Object)this, "selectionMode", SelectionMode.SINGLE){

                protected void invalidated() {
                    SelectionMode selectionMode = (SelectionMode)this.get();
                    WebFileOpenPicker.this.multiFileUploader.setSelectionMode(selectionMode);
                }
            };
        }
        return this.selectionMode;
    }

    @Override
    public final ObjectProperty<Consumer<List<? extends FileSource>>> onFilesSelectedProperty() {
        if (this.onFilesSelected == null) {
            this.onFilesSelected = new SimpleObjectProperty<Consumer<List<? extends FileSource>>>((Object)this, "onFilesSelected"){

                protected void invalidated() {
                    Consumer onFilesSelectedConsumer = (Consumer)this.get();
                    WebFileOpenPicker.this.multiFileUploader.setOnFilesSelected(onFilesSelectedConsumer == null ? null : jsFiles -> {
                        if (jsFiles != null) {
                            WebFileOpenPicker.this.webFileSources = new ArrayList<WebFileSource>(jsFiles.size());
                            jsFiles.stream().map(WebFileSource::new).forEach(WebFileOpenPicker.this.webFileSources::add);
                            onFilesSelectedConsumer.accept(WebFileOpenPicker.this.webFileSources);
                        }
                    });
                }
            };
        }
        return this.onFilesSelected;
    }
}

