/*
 * Decompiled with CFR 0.152.
 */
package one.jpro.platform.file.picker;

import com.jpro.webapi.WebAPI;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.nio.file.Path;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import javafx.application.Platform;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.property.SimpleStringProperty;
import javafx.beans.property.StringProperty;
import javafx.scene.Node;
import javafx.stage.Window;
import one.jpro.platform.file.ExtensionFilter;
import one.jpro.platform.file.FileStorage;
import one.jpro.platform.file.picker.BaseFileSavePicker;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WebFileSavePicker
extends BaseFileSavePicker {
    private static final Logger logger = LoggerFactory.getLogger(WebFileSavePicker.class);
    private StringProperty title;
    private ObjectProperty<File> initialDirectory;
    private ObjectProperty<File> tempDirectory;

    public WebFileSavePicker(Node node) {
        super(node);
    }

    @Override
    public final String getTitle() {
        return this.title != null ? (String)this.title.get() : null;
    }

    @Override
    public final void setTitle(String value) {
        this.titleProperty().set((Object)value);
    }

    @Override
    public final StringProperty titleProperty() {
        if (this.title == null) {
            this.title = new SimpleStringProperty((Object)this, "title");
        }
        return this.title;
    }

    @Override
    public final StringProperty initialFileNameProperty() {
        if (this.initialFileName == null) {
            this.initialFileName = new SimpleStringProperty((Object)this, "initialFileName");
        }
        return this.initialFileName;
    }

    @Override
    public final File getInitialDirectory() {
        return this.initialDirectory != null ? (File)this.initialDirectory.get() : null;
    }

    @Override
    public final void setInitialDirectory(File value) {
        this.initialDirectoryProperty().set((Object)value);
    }

    @Override
    public final ObjectProperty<File> initialDirectoryProperty() {
        if (this.initialDirectory == null) {
            this.initialDirectory = new SimpleObjectProperty((Object)this, "initialDirectory");
        }
        return this.initialDirectory;
    }

    public final File getTempDirectory() {
        return this.tempDirectory != null ? (File)this.tempDirectory.get() : null;
    }

    public final void setTempDirectory(File value) {
        this.tempDirectoryProperty().set((Object)value);
    }

    public final ObjectProperty<File> tempDirectoryProperty() {
        if (this.tempDirectory == null) {
            this.tempDirectory = new SimpleObjectProperty((Object)this, "tempDirectory");
        }
        return this.tempDirectory;
    }

    @Override
    final void showDialog() {
        String fileName = this.getInitialFileName() == null ? "filename" : this.getInitialFileName();
        ExtensionFilter extensionFilter = this.findSelectedFilter();
        String fileType = extensionFilter == null ? "" : extensionFilter.extensions().get(0);
        Function<File, CompletableFuture<Void>> onFileSelected = this.getOnFileSelected();
        if (onFileSelected != null) {
            try {
                Path tmpDir = this.getTempDirectory() != null ? this.getTempDirectory().toPath() : null;
                File tempFile = FileStorage.createTempFile(tmpDir, fileName, fileType).toFile();
                ((CompletableFuture)onFileSelected.apply(tempFile).thenCompose(nothing -> {
                    try {
                        URL fileUrl = tempFile.toURI().toURL();
                        WebAPI webAPI = WebAPI.getWebAPI((Window)this.getNode().getScene().getWindow());
                        Platform.runLater(() -> webAPI.downloadURL(fileUrl, tempFile::delete));
                        return CompletableFuture.completedFuture(nothing);
                    }
                    catch (IOException ex) {
                        return CompletableFuture.failedFuture(ex);
                    }
                })).exceptionallyCompose(ex -> {
                    if (!tempFile.delete()) {
                        logger.warn("Could not delete temporary file {}", (Object)tempFile.getAbsolutePath());
                    }
                    logger.error("Error while downloading file", ex);
                    return CompletableFuture.failedFuture(ex);
                });
            }
            catch (IOException ex2) {
                logger.error("Error creating temporary file for download", (Throwable)ex2);
            }
        }
    }
}

