/*
 * Decompiled with CFR 0.152.
 */
package one.jpro.platform.file;

import java.io.IOException;
import java.nio.file.FileSystem;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.nio.file.attribute.PosixFilePermission;
import java.nio.file.attribute.PosixFilePermissions;
import java.util.EnumSet;
import java.util.Objects;
import java.util.Set;
import org.jetbrains.annotations.Nullable;

public final class FileStorage {
    static final FileSystem DEFAULT_FILE_SYSTEM = FileSystems.getDefault();
    static final boolean isPosix = DEFAULT_FILE_SYSTEM.supportedFileAttributeViews().contains("posix");
    public static final Path JPRO_TMP_DIR = Path.of(System.getProperty("user.home"), ".jpro", "tmp");

    private static Path generatePath(String fileName, String fileType, Path dir) {
        Path name;
        Object s = fileName;
        int lastIndexOf = fileName.lastIndexOf(46);
        if (lastIndexOf > 0) {
            s = fileName.substring(0, lastIndexOf) + fileType;
        } else if (lastIndexOf == -1) {
            s = fileName + fileType;
        }
        if (Files.notExists(dir, new LinkOption[0])) {
            try {
                Files.createDirectories(dir, new FileAttribute[0]);
            }
            catch (IOException ex) {
                throw new IllegalArgumentException("Invalid directory path: " + String.valueOf(dir), ex);
            }
        }
        if ((name = dir.getFileSystem().getPath((String)s, new String[0])).getParent() != null) {
            throw new IllegalArgumentException("Invalid fileName: " + (String)s + ", it should not contain directory separators.");
        }
        return dir.resolve(name);
    }

    public static Path createTempFile(@Nullable Path dir, @Nullable String fileName, @Nullable String fileType) throws IOException {
        Path path;
        dir = Objects.requireNonNullElse(dir, JPRO_TMP_DIR);
        fileName = Objects.requireNonNullElse(fileName, "filename");
        fileType = Objects.requireNonNullElse(fileType, ".tmp");
        FileAttribute[] attrs = null;
        if (isPosix && dir.getFileSystem() == DEFAULT_FILE_SYSTEM) {
            attrs = new FileAttribute[]{PosixPermissions.filePermissions};
        }
        if (Files.exists(path = FileStorage.generatePath(fileName, fileType, dir), new LinkOption[0])) {
            return path;
        }
        return attrs != null ? Files.createFile(path, attrs) : Files.createFile(path, new FileAttribute[0]);
    }

    private FileStorage() {
    }

    static {
        try {
            if (Files.notExists(JPRO_TMP_DIR, new LinkOption[0])) {
                Files.createDirectories(JPRO_TMP_DIR, new FileAttribute[0]);
            }
        }
        catch (IOException e) {
            throw new ExceptionInInitializerError("Failed to create JPRO temporary directory: " + e.getMessage());
        }
    }

    private static class PosixPermissions {
        static final FileAttribute<Set<PosixFilePermission>> filePermissions = PosixFilePermissions.asFileAttribute(EnumSet.of(PosixFilePermission.OWNER_READ, PosixFilePermission.OWNER_WRITE));

        private PosixPermissions() {
        }
    }
}

