/*
 * Decompiled with CFR 0.152.
 */
package one.jpro.platform.file;

import java.io.File;
import java.util.concurrent.CompletableFuture;
import javafx.application.Platform;
import javafx.beans.property.ReadOnlyDoubleProperty;
import javafx.beans.property.ReadOnlyDoubleWrapper;
import javafx.beans.property.ReadOnlyObjectProperty;
import javafx.beans.property.ReadOnlyObjectWrapper;
import one.jpro.platform.file.FileSource;

public final class NativeFileSource
extends FileSource {
    private ReadOnlyDoubleWrapper progress;
    private ReadOnlyObjectWrapper<File> uploadedFile;

    public NativeFileSource(File file) {
        super(file);
    }

    @Override
    public File getPlatformFile() {
        return (File)super.getPlatformFile();
    }

    @Override
    String _getName() {
        return this.getPlatformFile().getName();
    }

    @Override
    long _getSize() {
        return this.getPlatformFile().length();
    }

    @Override
    public double getProgress() {
        return this.progress == null ? 0.0 : this.progress.get();
    }

    private void setProgress(double value) {
        this.progressPropertyImpl().set(value);
    }

    @Override
    public ReadOnlyDoubleProperty progressProperty() {
        return this.progressPropertyImpl().getReadOnlyProperty();
    }

    private ReadOnlyDoubleWrapper progressPropertyImpl() {
        if (this.progress == null) {
            this.progress = new ReadOnlyDoubleWrapper((Object)this, "progress", 0.0);
        }
        return this.progress;
    }

    @Override
    public File getUploadedFile() {
        return this.uploadedFile == null ? null : this.getPlatformFile();
    }

    private void setUploadedFile(File value) {
        this.uploadedFilePropertyImpl().set((Object)value);
    }

    @Override
    public ReadOnlyObjectProperty<File> uploadedFileProperty() {
        return this.uploadedFilePropertyImpl().getReadOnlyProperty();
    }

    private ReadOnlyObjectWrapper<File> uploadedFilePropertyImpl() {
        if (this.uploadedFile == null) {
            this.uploadedFile = new ReadOnlyObjectWrapper((Object)this, "uploadedFile");
        }
        return this.uploadedFile;
    }

    @Override
    public void uploadFile() {
        Runnable runnable = () -> {
            this.setProgress(1.0);
            this.setUploadedFile(this.getPlatformFile());
        };
        if (Platform.isFxApplicationThread()) {
            runnable.run();
        } else {
            Platform.runLater((Runnable)runnable);
        }
    }

    @Override
    public CompletableFuture<File> uploadFileAsync() {
        return CompletableFuture.supplyAsync(() -> {
            this.uploadFile();
            return this.getPlatformFile();
        });
    }
}

