/*
 * Decompiled with CFR 0.152.
 */
package one.jpro.platform.file.picker;

import com.jpro.webapi.WebAPI;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.function.Consumer;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.collections.ListChangeListener;
import javafx.collections.WeakListChangeListener;
import javafx.scene.Node;
import javafx.scene.control.SelectionMode;
import one.jpro.platform.file.ExtensionFilter;
import one.jpro.platform.file.FileSource;
import one.jpro.platform.file.WebFileSource;
import one.jpro.platform.file.picker.BaseFileOpenPicker;
import one.jpro.platform.file.util.NodeUtils;

public class WebFileOpenPicker
extends BaseFileOpenPicker {
    private final WebAPI.MultiFileUploader multiFileUploader;
    private final ListChangeListener<ExtensionFilter> webExtensionFilterListChangeListener;
    private List<WebFileSource> webFileSources = List.of();

    public WebFileOpenPicker(Node node) {
        super(node);
        this.multiFileUploader = NodeUtils.getPropertyValue(node, NodeUtils.MULTI_FILE_UPLOADER_KEY, WebAPI.makeMultiFileUploadNodeStatic((Node)node));
        this.multiFileUploader.setSelectFileOnClick(Boolean.valueOf(true));
        this.webExtensionFilterListChangeListener = change -> {
            List supportedExtensionsList = change.getList().stream().flatMap(ext -> ext.extensions().stream()).toList();
            HashSet supportedExtensionsSet = new HashSet(supportedExtensionsList);
            this.multiFileUploader.supportedExtensions().setAll(supportedExtensionsSet.stream().toList());
        };
        this.getExtensionFilters().addListener((ListChangeListener)new WeakListChangeListener(this.webExtensionFilterListChangeListener));
    }

    @Override
    public final ObjectProperty<SelectionMode> selectionModeProperty() {
        if (this.selectionMode == null) {
            this.selectionMode = new SimpleObjectProperty<SelectionMode>((Object)this, "selectionMode", SelectionMode.SINGLE){

                protected void invalidated() {
                    SelectionMode selectionMode = (SelectionMode)this.get();
                    WebFileOpenPicker.this.multiFileUploader.setSelectionMode(selectionMode);
                }
            };
        }
        return this.selectionMode;
    }

    @Override
    public final ObjectProperty<Consumer<List<? extends FileSource>>> onFilesSelectedProperty() {
        if (this.onFilesSelected == null) {
            this.onFilesSelected = new SimpleObjectProperty<Consumer<List<? extends FileSource>>>((Object)this, "onFilesSelected"){

                protected void invalidated() {
                    Consumer onFilesSelectedConsumer = (Consumer)this.get();
                    WebFileOpenPicker.this.multiFileUploader.setOnFilesSelected(onFilesSelectedConsumer == null ? null : jsFiles -> {
                        if (jsFiles != null) {
                            WebFileOpenPicker.this.webFileSources = new ArrayList<WebFileSource>(jsFiles.size());
                            jsFiles.stream().map(WebFileSource::new).forEach(WebFileOpenPicker.this.webFileSources::add);
                            onFilesSelectedConsumer.accept(WebFileOpenPicker.this.webFileSources);
                        }
                    });
                }
            };
        }
        return this.onFilesSelected;
    }
}

