/*
 * Decompiled with CFR 0.152.
 */
package one.jpro.platform.file.dropper;

import java.util.List;
import java.util.function.Consumer;
import javafx.beans.property.ReadOnlyBooleanProperty;
import javafx.beans.property.ReadOnlyBooleanWrapper;
import javafx.event.Event;
import javafx.event.EventTarget;
import javafx.scene.Node;
import javafx.scene.control.SelectionMode;
import javafx.scene.input.DragEvent;
import javafx.scene.input.TransferMode;
import one.jpro.platform.file.ExtensionFilter;
import one.jpro.platform.file.NativeFileSource;
import one.jpro.platform.file.dropper.BaseFileDropper;
import one.jpro.platform.file.event.DataTransfer;
import one.jpro.platform.file.event.FileDragEvent;
import one.jpro.platform.file.util.NodeUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NativeFileDropper
extends BaseFileDropper {
    private static final Logger logger = LoggerFactory.getLogger(NativeFileDropper.class);
    private ReadOnlyBooleanWrapper filesDragOver;

    public NativeFileDropper(Node node) {
        super(node);
        NodeUtils.addEventHandler(node, DragEvent.DRAG_OVER, dragEvent -> {
            if (dragEvent.getDragboard().hasFiles()) {
                List files = dragEvent.getDragboard().getFiles();
                if (this.hasSupportedExtension(files)) {
                    dragEvent.acceptTransferModes(new TransferMode[]{TransferMode.COPY});
                    this.setFilesDragOver(true);
                } else {
                    dragEvent.acceptTransferModes(TransferMode.NONE);
                    this.setFilesDragOver(false);
                }
            }
        });
        NodeUtils.addEventHandler(node, DragEvent.DRAG_ENTERED, dragEvent -> {
            FileDragEvent fileDragEvent = new FileDragEvent((Object)this, (EventTarget)this.getNode(), FileDragEvent.FILE_DRAG_ENTERED);
            if (dragEvent.getDragboard().hasFiles()) {
                List files = dragEvent.getDragboard().getFiles();
                fileDragEvent.getDataTransfer().putData(DataTransfer.FILES, files);
            }
            Event.fireEvent((EventTarget)this, (Event)fileDragEvent);
        });
        NodeUtils.addEventHandler(node, DragEvent.DRAG_EXITED, dragEvent -> Event.fireEvent((EventTarget)this, (Event)new FileDragEvent((Object)this, (EventTarget)this.getNode(), FileDragEvent.FILE_DRAG_EXITED)));
        NodeUtils.addEventHandler(node, DragEvent.DRAG_DROPPED, dragEvent -> {
            if (dragEvent.getDragboard().hasFiles()) {
                ExtensionFilter extensionFilter = this.getExtensionFilter();
                boolean allowDirectory = extensionFilter.allowDirectory();
                List<NativeFileSource> nativeFileSources = dragEvent.getDragboard().getFiles().stream().filter(file -> extensionFilter != null && extensionFilter.extensions().stream().anyMatch(extension -> {
                    if (file.isDirectory()) {
                        return allowDirectory;
                    }
                    return file.getName().toLowerCase().endsWith((String)extension);
                })).map(NativeFileSource::new).toList();
                Consumer onFilesSelectedConsumer = this.getOnFilesSelected();
                if (onFilesSelectedConsumer != null) {
                    if (this.getSelectionMode() == SelectionMode.SINGLE) {
                        nativeFileSources = List.of(nativeFileSources.get(0));
                    }
                    onFilesSelectedConsumer.accept(nativeFileSources);
                }
            }
        });
    }

    @Override
    public boolean isFilesDragOver() {
        return this.filesDragOver != null && this.filesDragOver.get();
    }

    void setFilesDragOver(boolean value) {
        this.filesDragOverPropertyImpl().set(value);
    }

    @Override
    public ReadOnlyBooleanProperty filesDragOverProperty() {
        return this.filesDragOverPropertyImpl().getReadOnlyProperty();
    }

    private ReadOnlyBooleanWrapper filesDragOverPropertyImpl() {
        if (this.filesDragOver == null) {
            this.filesDragOver = new ReadOnlyBooleanWrapper((Object)this, "filesDragOver", false);
        }
        return this.filesDragOver;
    }
}

