/*
 * Decompiled with CFR 0.152.
 */
package one.jpro.platform.file.dropper;

import com.jpro.webapi.WebAPI;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import javafx.beans.InvalidationListener;
import javafx.beans.WeakInvalidationListener;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.ReadOnlyBooleanProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.collections.ObservableList;
import javafx.event.Event;
import javafx.event.EventTarget;
import javafx.scene.Node;
import javafx.scene.control.SelectionMode;
import one.jpro.platform.file.FileSource;
import one.jpro.platform.file.WebFileSource;
import one.jpro.platform.file.dropper.BaseFileDropper;
import one.jpro.platform.file.event.DataTransfer;
import one.jpro.platform.file.event.FileDragEvent;
import one.jpro.platform.file.util.NodeUtils;

public class WebFileDropper
extends BaseFileDropper {
    private final WebAPI.MultiFileUploader multiFileUploader;
    private List<WebFileSource> webFileSources = List.of();
    private final InvalidationListener fileDragOverListener;

    public WebFileDropper(Node node) {
        super(node);
        this.multiFileUploader = NodeUtils.getPropertyValue(node, NodeUtils.MULTI_FILE_UPLOADER_KEY, WebAPI.makeMultiFileUploadNodeStatic((Node)node));
        this.multiFileUploader.setSelectFileOnDrop(Boolean.valueOf(true));
        this.fileDragOverListener = observable -> {
            if (this.multiFileUploader.getFileDragOver()) {
                FileDragEvent fileDragEvent = new FileDragEvent((Object)this, (EventTarget)this.getNode(), FileDragEvent.FILE_DRAG_ENTERED);
                ObservableList fileMimeTypes = this.multiFileUploader.getFilesDragOverTypes();
                if (!fileMimeTypes.isEmpty()) {
                    fileDragEvent.getDataTransfer().putData(DataTransfer.MIME_TYPES, fileMimeTypes);
                }
                Event.fireEvent((EventTarget)this, (Event)fileDragEvent);
            } else {
                Event.fireEvent((EventTarget)this, (Event)new FileDragEvent((Object)this, (EventTarget)this.getNode(), FileDragEvent.FILE_DRAG_EXITED));
            }
        };
        this.multiFileUploader.fileDragOverProperty().addListener((InvalidationListener)new WeakInvalidationListener(this.fileDragOverListener));
    }

    @Override
    public final ObjectProperty<SelectionMode> selectionModeProperty() {
        if (this.selectionMode == null) {
            this.selectionMode = new SimpleObjectProperty<SelectionMode>((Object)this, "selectionMode", SelectionMode.SINGLE){

                protected void invalidated() {
                    SelectionMode selectionMode = (SelectionMode)this.get();
                    WebFileDropper.this.multiFileUploader.setSelectionMode(selectionMode);
                }
            };
        }
        return this.selectionMode;
    }

    @Override
    public final ObjectProperty<Consumer<List<? extends FileSource>>> onFilesSelectedProperty() {
        if (this.onFilesSelected == null) {
            this.onFilesSelected = new SimpleObjectProperty<Consumer<List<? extends FileSource>>>((Object)this, "onFilesSelected"){

                protected void invalidated() {
                    Consumer onFilesSelectedConsumer = (Consumer)this.get();
                    WebFileDropper.this.multiFileUploader.setOnFilesSelected(onFilesSelectedConsumer == null ? null : jsFiles -> {
                        if (jsFiles != null) {
                            WebFileDropper.this.webFileSources = new ArrayList<WebFileSource>(jsFiles.size());
                            jsFiles.stream().map(WebFileSource::new).forEach(WebFileDropper.this.webFileSources::add);
                            onFilesSelectedConsumer.accept(WebFileDropper.this.webFileSources);
                        }
                    });
                }
            };
        }
        return this.onFilesSelected;
    }

    @Override
    public final boolean isFilesDragOver() {
        return this.multiFileUploader.getFileDragOver();
    }

    @Override
    public final ReadOnlyBooleanProperty filesDragOverProperty() {
        return this.multiFileUploader.fileDragOverProperty();
    }

    public final ObservableList<String> getFilesDragOverTypes() {
        return this.multiFileUploader.getFilesDragOverTypes();
    }
}

