/*
 * Decompiled with CFR 0.152.
 */
package one.jpro.platform.file;

import java.util.List;
import javafx.stage.FileChooser;

public record ExtensionFilter(String description, boolean allowDirectory, List<String> extensions) {
    public static final ExtensionFilter ANY = new ExtensionFilter("All Files", false, List.of("."));
    public static final ExtensionFilter DIRECTORY = new ExtensionFilter("Directory", true, List.of());

    public ExtensionFilter {
        ExtensionFilter.validateArgs(description, extensions);
    }

    public ExtensionFilter(String description, String ... extension) {
        this(description, false, List.of(extension));
    }

    public static ExtensionFilter of(String description, String ... extensions) {
        return new ExtensionFilter(description, false, List.of(extensions));
    }

    public static ExtensionFilter of(String description, boolean allowDirectory, String ... extensions) {
        return new ExtensionFilter(description, allowDirectory, List.of(extensions));
    }

    public static FileChooser.ExtensionFilter toJavaFXExtensionFilter(ExtensionFilter extensionFilter) {
        if (extensionFilter == null) {
            return null;
        }
        if (extensionFilter.allowDirectory()) {
            return new FileChooser.ExtensionFilter(extensionFilter.description(), new String[]{"*"});
        }
        return new FileChooser.ExtensionFilter(extensionFilter.description(), extensionFilter.extensions().stream().map(ext -> "*" + ext).toList());
    }

    public static ExtensionFilter fromJavaFXExtensionFilter(FileChooser.ExtensionFilter extensionFilter) {
        if (extensionFilter == null) {
            return null;
        }
        return new ExtensionFilter(extensionFilter.getDescription(), false, extensionFilter.getExtensions().stream().filter(ext -> ext.startsWith("*")).map(ext -> ext.substring(1)).toList());
    }

    private static void validateArgs(String description, List<String> extensions) {
        if (description == null) {
            throw new NullPointerException("Description must not be null");
        }
        if (description.isEmpty()) {
            throw new IllegalArgumentException("Description must not be empty");
        }
        if (extensions == null) {
            throw new NullPointerException("Extensions must not be null");
        }
        for (String extension : extensions) {
            if (extension == null) {
                throw new NullPointerException("Extension must not be null");
            }
            if (extension.isEmpty()) {
                throw new IllegalArgumentException("Extension must not be empty");
            }
            if (!extension.startsWith("*")) continue;
            throw new IllegalArgumentException("Extension with regex is not supported");
        }
    }
}

