/*
 * Decompiled with CFR 0.152.
 */
package one.jpro.platform.file.picker;

import java.io.File;
import java.util.Objects;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.property.SimpleStringProperty;
import javafx.beans.property.StringProperty;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.scene.Node;
import javafx.stage.FileChooser;
import one.jpro.platform.file.ExtensionFilter;
import one.jpro.platform.file.picker.FilePicker;

abstract class BaseFilePicker
implements FilePicker {
    private final Node node;
    private StringProperty initialFileName;
    private ObjectProperty<File> initialDirectory;
    private StringProperty title;
    private final ObservableList<ExtensionFilter> extensionFilters = FXCollections.observableArrayList();
    private ObjectProperty<ExtensionFilter> selectedExtensionFilter;

    BaseFilePicker(Node node) {
        this.node = Objects.requireNonNull(node, "node must not be null");
    }

    @Override
    public final Node getNode() {
        return this.node;
    }

    @Override
    public final String getInitialFileName() {
        return this.initialFileName == null ? null : (String)this.initialFileName.get();
    }

    @Override
    public final void setInitialFileName(String value) {
        this.initialFileNameProperty().set((Object)value);
    }

    @Override
    public final StringProperty initialFileNameProperty() {
        if (this.initialFileName == null) {
            this.initialFileName = new SimpleStringProperty((Object)this, "initialFileName");
        }
        return this.initialFileName;
    }

    @Override
    public final File getInitialDirectory() {
        return this.initialDirectory != null ? (File)this.initialDirectory.get() : null;
    }

    @Override
    public final void setInitialDirectory(File value) {
        this.initialDirectoryProperty().set((Object)value);
    }

    @Override
    public final ObjectProperty<File> initialDirectoryProperty() {
        if (this.initialDirectory == null) {
            this.initialDirectory = new SimpleObjectProperty((Object)this, "initialDirectory");
        }
        return this.initialDirectory;
    }

    @Override
    public final String getTitle() {
        return (String)this.title.get();
    }

    @Override
    public final void setTitle(String value) {
        this.titleProperty().set((Object)value);
    }

    @Override
    public final StringProperty titleProperty() {
        if (this.title == null) {
            this.title = new SimpleStringProperty((Object)this, "title");
        }
        return this.title;
    }

    @Override
    public final ObservableList<ExtensionFilter> getExtensionFilters() {
        return this.extensionFilters;
    }

    @Override
    public final ExtensionFilter getSelectedExtensionFilter() {
        return this.selectedExtensionFilter != null ? (ExtensionFilter)this.selectedExtensionFilter.get() : null;
    }

    @Override
    public final void setSelectedExtensionFilter(ExtensionFilter value) {
        this.selectedExtensionFilterProperty().set((Object)value);
    }

    @Override
    public final ObjectProperty<ExtensionFilter> selectedExtensionFilterProperty() {
        if (this.selectedExtensionFilter == null) {
            this.selectedExtensionFilter = new SimpleObjectProperty((Object)this, "selectedExtensionFilter");
        }
        return this.selectedExtensionFilter;
    }

    final ExtensionFilter findSelectedFilter() {
        ExtensionFilter selectedFilter = this.getSelectedExtensionFilter();
        if (selectedFilter == null || !this.extensionFilters.contains((Object)selectedFilter)) {
            return this.extensionFilters.isEmpty() ? null : (ExtensionFilter)this.extensionFilters.get(0);
        }
        return selectedFilter;
    }

    final void setNativeSelectedExtensionFilter(FileChooser fileChooser, ExtensionFilter newFilter) {
        FileChooser.ExtensionFilter extensionFilter = null;
        if (newFilter != null) {
            for (FileChooser.ExtensionFilter ef : fileChooser.getExtensionFilters()) {
                if (!newFilter.description().equals(ef.getDescription())) continue;
                extensionFilter = ef;
                break;
            }
        }
        fileChooser.setSelectedExtensionFilter(extensionFilter);
    }
}

