/*
 * Decompiled with CFR 0.152.
 */
package one.jpro.platform.file.picker;

import java.io.File;
import java.util.List;
import java.util.function.Consumer;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.value.ObservableValue;
import javafx.scene.Node;
import javafx.scene.control.SelectionMode;
import javafx.scene.input.MouseEvent;
import javafx.stage.DirectoryChooser;
import javafx.stage.FileChooser;
import javafx.stage.Window;
import one.jpro.platform.file.ExtensionFilter;
import one.jpro.platform.file.FileSource;
import one.jpro.platform.file.NativeFileSource;
import one.jpro.platform.file.picker.BaseFileOpenPicker;
import one.jpro.platform.file.util.NodeUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NativeFileOpenPicker
extends BaseFileOpenPicker {
    private static final Logger LOGGER = LoggerFactory.getLogger(NativeFileOpenPicker.class);
    private List<NativeFileSource> nativeFileSources = List.of();

    public NativeFileOpenPicker(Node node) {
        super(node);
        NodeUtils.addEventHandler(node, MouseEvent.MOUSE_CLICKED, actionEvent -> {
            Window window = node.getScene().getWindow();
            boolean useDirectory = this.getExtensionFilters().stream().anyMatch(ExtensionFilter::allowDirectory);
            boolean hasFilesTypes = this.getExtensionFilters().stream().anyMatch(x -> !x.extensions().isEmpty());
            if (useDirectory && hasFilesTypes) {
                LOGGER.warn("You can't use directory and file types at the same time. Directory will be used.");
            }
            if (useDirectory) {
                DirectoryChooser directoryChooser = this.createDirectoryChooser();
                File file = directoryChooser.showDialog(window);
                if (file != null) {
                    this.nativeFileSources = List.of(new NativeFileSource(file));
                    Consumer<List<? extends FileSource>> onFilesSelectedConsumer = this.getOnFilesSelected();
                    if (onFilesSelectedConsumer != null) {
                        onFilesSelectedConsumer.accept(this.nativeFileSources);
                    }
                }
            } else if (this.getSelectionMode() == SelectionMode.MULTIPLE) {
                FileChooser fileChooser = this.createFileChooser();
                List files = fileChooser.showOpenMultipleDialog(window);
                if (files != null && !files.isEmpty()) {
                    this.nativeFileSources = files.stream().map(NativeFileSource::new).toList();
                    Consumer<List<? extends FileSource>> onFilesSelectedConsumer = this.getOnFilesSelected();
                    if (onFilesSelectedConsumer != null) {
                        onFilesSelectedConsumer.accept(this.nativeFileSources);
                    }
                }
            } else {
                FileChooser fileChooser = this.createFileChooser();
                File file = fileChooser.showOpenDialog(window);
                if (file != null) {
                    this.nativeFileSources = List.of(new NativeFileSource(file));
                    Consumer<List<? extends FileSource>> onFilesSelectedConsumer = this.getOnFilesSelected();
                    if (onFilesSelectedConsumer != null) {
                        onFilesSelectedConsumer.accept(this.nativeFileSources);
                    }
                }
            }
        });
    }

    @Override
    public final ObjectProperty<SelectionMode> selectionModeProperty() {
        if (this.selectionMode == null) {
            this.selectionMode = new SimpleObjectProperty((Object)this, "selectionMode", (Object)SelectionMode.SINGLE);
        }
        return this.selectionMode;
    }

    FileChooser createFileChooser() {
        FileChooser fileChooser = new FileChooser();
        fileChooser.titleProperty().bind((ObservableValue)this.titleProperty());
        fileChooser.initialDirectoryProperty().bind(this.initialDirectoryProperty());
        fileChooser.initialFileNameProperty().bind((ObservableValue)this.initialFileNameProperty());
        fileChooser.getExtensionFilters().addAll(this.getExtensionFilters().stream().map(ExtensionFilter::toJavaFXExtensionFilter).toList());
        this.setNativeSelectedExtensionFilter(fileChooser, this.getSelectedExtensionFilter());
        return fileChooser;
    }

    DirectoryChooser createDirectoryChooser() {
        DirectoryChooser directoryChooser = new DirectoryChooser();
        directoryChooser.titleProperty().bind((ObservableValue)this.titleProperty());
        directoryChooser.initialDirectoryProperty().bind(this.initialDirectoryProperty());
        return directoryChooser;
    }
}

