/*
 * Decompiled with CFR 0.152.
 */
package one.jpro.platform.file.picker;

import java.io.File;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import javafx.beans.value.ObservableValue;
import javafx.scene.Node;
import javafx.scene.Scene;
import javafx.stage.FileChooser;
import javafx.stage.Window;
import one.jpro.platform.file.ExtensionFilter;
import one.jpro.platform.file.picker.BaseFileSavePicker;

public class NativeFileSavePicker
extends BaseFileSavePicker {
    public NativeFileSavePicker(Node node) {
        super(node);
    }

    @Override
    final void showDialog() {
        Function<File, CompletableFuture<Void>> onFileSelected;
        FileChooser fileChooser = this.createFileChooser();
        Scene scene = this.getNode().getScene();
        if (scene == null) {
            throw new IllegalStateException("Node must be attached to a scene");
        }
        Window window = scene.getWindow();
        if (window == null) {
            throw new IllegalStateException("Scene must be attached to a stage");
        }
        File saveToFile = fileChooser.showSaveDialog(window);
        if (saveToFile != null && (onFileSelected = this.getOnFileSelected()) != null) {
            onFileSelected.apply(saveToFile);
        }
    }

    FileChooser createFileChooser() {
        FileChooser fileChooser = new FileChooser();
        fileChooser.titleProperty().bind((ObservableValue)this.titleProperty());
        fileChooser.initialDirectoryProperty().bind(this.initialDirectoryProperty());
        fileChooser.initialFileNameProperty().bind((ObservableValue)this.initialFileNameProperty());
        fileChooser.getExtensionFilters().addAll(this.getExtensionFilters().stream().map(ExtensionFilter::toJavaFXExtensionFilter).toList());
        this.setNativeSelectedExtensionFilter(fileChooser, this.getSelectedExtensionFilter());
        return fileChooser;
    }
}

