/*
 * Decompiled with CFR 0.152.
 */
package one.jpro.platform.file.util;

import javafx.collections.ObservableMap;
import javafx.event.Event;
import javafx.event.EventHandler;
import javafx.event.EventType;
import javafx.scene.Node;

public interface NodeUtils {
    public static final Object MULTI_FILE_UPLOADER_KEY = new Object();
    public static final Object EVENT_HANDLER_KEY = new Object();

    public static <K, V> V getPropertyValue(Node node, K key, V defaultValue) {
        ObservableMap nodeProperties = node.getProperties();
        if (nodeProperties.containsKey(key)) {
            return nodeProperties.get(key);
        }
        nodeProperties.put(key, defaultValue);
        return defaultValue;
    }

    public static <T extends Event> void addEventHandler(Node node, EventType<T> eventType, EventHandler<? super T> eventHandler) {
        String eventTypeKey;
        ObservableMap nodeProperties = node.getProperties();
        if (nodeProperties.containsKey(eventTypeKey = String.valueOf(EVENT_HANDLER_KEY) + "_" + eventType.getName())) {
            EventHandler oldEventHandler = (EventHandler)nodeProperties.get(eventTypeKey);
            node.removeEventHandler(eventType, oldEventHandler);
        }
        node.addEventHandler(eventType, eventHandler);
        nodeProperties.put(eventTypeKey, eventHandler);
    }
}

