/*
 * Decompiled with CFR 0.152.
 */
package one.jpro.platform.file.util;

import com.jpro.webapi.WebAPI;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import javafx.application.Platform;
import javafx.stage.FileChooser;
import javafx.stage.Stage;
import javafx.stage.Window;
import one.jpro.platform.file.ExtensionFilter;
import one.jpro.platform.file.FileStorage;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public interface SaveUtils {
    public static CompletableFuture<File> save(@NotNull File fileToSave, @Nullable String fileType, @NotNull Function<File, CompletableFuture<File>> saveFunction) {
        Object filePath;
        int lastDotIndex;
        Objects.requireNonNull(fileToSave, "File to save to cannot be null");
        if (fileType == null) {
            fileType = "";
        }
        if ((lastDotIndex = ((String)(filePath = fileToSave.getAbsolutePath())).lastIndexOf(".")) > 0) {
            filePath = ((String)filePath).substring(0, lastDotIndex) + fileType;
        }
        return saveFunction.apply(new File((String)filePath));
    }

    public static CompletableFuture<File> saveAs(@NotNull Stage stage, @NotNull String fileName, @Nullable String fileType, @NotNull Function<File, CompletableFuture<File>> saveFunction) {
        FileChooser fileChooser = new FileChooser();
        fileChooser.setTitle("Save file as...");
        fileChooser.setInitialFileName(fileName);
        ExtensionFilter extensionFilter = ExtensionFilter.of(fileType, fileType);
        FileChooser.ExtensionFilter extFilter = new FileChooser.ExtensionFilter(extensionFilter.description(), (String[])extensionFilter.extensions().stream().map(ext -> "*" + ext).toArray(String[]::new));
        fileChooser.getExtensionFilters().add((Object)extFilter);
        fileChooser.setSelectedExtensionFilter(extFilter);
        File saveToFile = fileChooser.showSaveDialog((Window)stage);
        if (saveToFile != null) {
            return saveFunction.apply(saveToFile);
        }
        return CompletableFuture.failedFuture(new NullPointerException("File to save to is null"));
    }

    public static CompletableFuture<File> download(@NotNull Stage stage, @NotNull String fileName, @Nullable String fileType, @NotNull Function<File, CompletableFuture<Void>> saveFunction) throws IOException {
        return SaveUtils.download(stage, FileStorage.JPRO_TMP_DIR.toFile(), fileName, fileType, saveFunction);
    }

    public static CompletableFuture<File> download(@NotNull Stage stage, @NotNull File tmpDir, @NotNull String fileName, @Nullable String fileType, @NotNull Function<File, CompletableFuture<Void>> saveFunction) throws IOException {
        if (WebAPI.isBrowser()) {
            WebAPI webAPI = WebAPI.getWebAPI((Window)stage);
            Logger logger = LoggerFactory.getLogger(SaveUtils.class);
            File tempFile = FileStorage.createTempFile(tmpDir.toPath(), fileName, fileType).toFile();
            return ((CompletableFuture)saveFunction.apply(tempFile).thenCompose(nothing -> {
                try {
                    URL fileUrl = tempFile.toURI().toURL();
                    Platform.runLater(() -> webAPI.downloadURL(fileUrl, tempFile::delete));
                    return CompletableFuture.completedFuture(tempFile);
                }
                catch (IOException ex) {
                    return CompletableFuture.failedFuture(ex);
                }
            })).exceptionallyCompose(ex -> {
                if (!tempFile.delete()) {
                    logger.warn("Could not delete temporary file {}", (Object)tempFile.getAbsolutePath());
                }
                logger.error("Error while downloading file", ex);
                return CompletableFuture.failedFuture(ex);
            });
        }
        throw new UnsupportedOperationException("Download is only supported in the browser");
    }
}

