/*
 * Decompiled with CFR 0.152.
 */
package one.jpro.platform.htmlscrollpane;

import com.jpro.webapi.HTMLView;
import com.jpro.webapi.WebAPI;
import java.lang.ref.WeakReference;
import java.lang.reflect.Field;
import java.util.List;
import java.util.Random;
import javafx.application.Platform;
import javafx.beans.property.Property;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.beans.value.WeakChangeListener;
import javafx.geometry.Orientation;
import javafx.scene.Node;
import javafx.scene.Scene;
import javafx.scene.control.Control;
import javafx.scene.control.PopupControl;
import javafx.scene.control.ScrollPane;
import javafx.scene.control.Skin;
import javafx.scene.control.SkinBase;
import javafx.scene.control.Skinnable;
import javafx.scene.layout.Pane;
import javafx.scene.layout.Region;
import javafx.scene.layout.StackPane;
import javafx.stage.PopupWindow;
import javafx.stage.Window;
import one.jpro.jmemorybuddy.CleanupDetector;
import one.jpro.platform.utils.TreeShowing;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HTMLScrollPaneSkin
extends SkinBase<ScrollPane> {
    private static final Logger logger = LoggerFactory.getLogger(HTMLScrollPaneSkin.class);
    final StackPane viewContent;
    final HTMLView htmlView;
    final Node cssBridgeTarget;
    final String attributes;
    Pane htmlViewContent;
    ChangeListener<Number> widthListener;

    public HTMLScrollPaneSkin(ScrollPane control) {
        this(control, "");
    }

    public HTMLScrollPaneSkin(ScrollPane control, String attributes) {
        super((Control)control);
        this.attributes = attributes;
        this.viewContent = new StackPane();
        this.htmlView = new HTMLView();
        this.cssBridgeTarget = new Pane();
        this.cssBridgeTarget.setId("cssBridgeTarget");
        this.htmlView.blockMouseInputProperty().set(true);
        this.htmlView.setMinHeight(500.0);
        TreeShowing.treeShowing((Node)control).addListener((p, o, n) -> {
            if (n.booleanValue()) {
                this.getChildren().add((Object)this.cssBridgeTarget);
            } else {
                this.getChildren().remove((Object)this.cssBridgeTarget);
                HTMLScrollPaneSkin.workaroundRemovePeerParent(this.cssBridgeTarget);
            }
        });
        WebAPI.getWebAPI((Node)control, webapi -> {
            this.htmlViewContent = new HorizontalStackPane();
            this.htmlViewContent.setId("scrollpaneskin_htmlViewContent");
            this.viewContent.getChildren().add((Object)this.htmlView);
            this.getChildren().add((Object)this.viewContent);
            Runnable updateContent = () -> {
                if (TreeShowing.treeShowing((Node)control).get()) {
                    this.htmlViewContent.getChildren().setAll((Object[])new Node[]{control.getContent()});
                } else {
                    this.htmlViewContent.getChildren().clear();
                }
            };
            this.setupHTMLView(webapi);
            this.registerChangeListener((ObservableValue)control.contentProperty(), e -> {
                logger.debug("Trigger: content");
                updateContent.run();
            });
            this.registerChangeListener((ObservableValue)TreeShowing.treeShowing((Node)control), e -> {
                logger.debug("Trigger: tree-showing");
                updateContent.run();
            });
            updateContent.run();
        });
    }

    public void setupHTMLView(WebAPI webapi) {
        PopupControl contentPage = new PopupControl();
        contentPage.setSkin((Skin)new WeakPopupControlSkin((Node)this.htmlViewContent));
        String windowId = webapi.registerWindow((Window)contentPage);
        this.widthListener = (p, o, n) -> this.htmlViewContent.prefWidthProperty().set(n.doubleValue());
        ((Region)this.getNode()).widthProperty().addListener((ChangeListener)new WeakChangeListener(this.widthListener));
        this.htmlViewContent.prefWidthProperty().set(((Region)this.getNode()).getWidth());
        contentPage.show(this.cssBridgeTarget, 0.0, 0.0);
        Node localCssBridgeTarget = this.cssBridgeTarget;
        this.cssBridgeTarget.sceneProperty().addListener((p, o, n) -> {
            if (n != null) {
                contentPage.show(localCssBridgeTarget, 0.0, 0.0);
            } else {
                contentPage.hide();
                HTMLScrollPaneSkin.workaroundClearNewEventTargets(contentPage.getScene());
                HTMLScrollPaneSkin.workaroundOwnerWindow((Window)contentPage);
            }
        });
        String number = "" + new Random().nextInt(1000000);
        String id = "scrollelem_" + number;
        String idapp = "scrollelemapp_" + number;
        String content = "<div id=\"" + id + "\" style=\"overflow-x: hidden; overflow-y:scroll; \"><jpro-app loader=\"none\" id=\"" + idapp + "\" href=\"/app/" + windowId + "\" fxwidth=\"true\" fxheight=\"true\" nativeScrolling=\"true\" " + this.attributes + "></jpro-app></div>";
        logger.debug("Setting content to: " + content);
        webapi.executeScript("jpro." + idapp + " = document.getElementById('" + idapp + "');");
        CleanupDetector.onCleanup((Object)((Object)this), (Runnable)new WeakCleanupRunnable(webapi, "console.log('DISPOSING');jpro." + idapp + ".jproimpl.dispose();delete jpro." + idapp + ";console.log('Disposed jpro." + idapp + "');", WebAPI.getWebAPI((Window)contentPage)));
        ((Region)this.getNode()).widthProperty().addListener((p, o, n) -> webapi.executeScript("document.getElementById('" + id + "').style.width = '" + String.valueOf(n) + "px';"));
        webapi.executeScript("document.getElementById('" + id + "').style.width = '" + ((Region)this.getNode()).getWidth() + "px';");
        ((Region)this.getNode()).heightProperty().addListener((p, o, n) -> webapi.executeScript("document.getElementById('" + id + "').style.height = '" + String.valueOf(n) + "px';"));
        webapi.executeScript("document.getElementById('" + id + "').style.height = '" + ((Region)this.getNode()).getHeight() + "px';");
        this.htmlView.setContent(content);
    }

    public static void workaroundRemovePeerParent(Node node) {
        try {
            Field parentField = Node.class.getDeclaredField("peer");
            parentField.setAccessible(true);
            Object peer = parentField.get(node);
            if (peer != null) {
                Class<?> ngNode = peer.getClass().getClassLoader().loadClass("com.sun.javafx.sg.prism.NGNode");
                parentField = ngNode.getDeclaredField("parent");
                parentField.setAccessible(true);
                parentField.set(peer, null);
            }
        }
        catch (Exception ex) {
            logger.error("Error while removing peer parent", (Throwable)ex);
        }
    }

    public static void workaroundClearNewEventTargets(Scene scene) {
        try {
            Field mouseHandlerField = Scene.class.getDeclaredField("mouseHandler");
            mouseHandlerField.setAccessible(true);
            Object mouseHandler = mouseHandlerField.get(scene);
            if (mouseHandler != null) {
                Class<?> mouseHandlerClass = mouseHandler.getClass();
                Field newEventTargetsField = mouseHandlerClass.getDeclaredField("newEventTargets");
                newEventTargetsField.setAccessible(true);
                List newEventTargets = (List)newEventTargetsField.get(mouseHandler);
                if (newEventTargets != null) {
                    newEventTargets.clear();
                }
            }
        }
        catch (Exception ex) {
            logger.error("Error while clearing newEventTargets", (Throwable)ex);
        }
    }

    public static void workaroundOwnerWindow(Window window) {
        try {
            Field ownerNodeField = PopupWindow.class.getDeclaredField("ownerWindow");
            ownerNodeField.setAccessible(true);
            Property p = (Property)ownerNodeField.get(window);
            p.setValue(null);
        }
        catch (Exception ex) {
            logger.error("Error while setting ownerWindow to null", (Throwable)ex);
        }
    }

    static class WeakPopupControlSkin
    implements Skin {
        WeakReference<Node> whtmlViewContent;

        public WeakPopupControlSkin(Node n) {
            this.whtmlViewContent = new WeakReference<Node>(n);
        }

        public Skinnable getSkinnable() {
            return null;
        }

        public Node getNode() {
            return (Node)this.whtmlViewContent.get();
        }

        public void dispose() {
        }
    }

    static class WeakCleanupRunnable
    implements Runnable {
        WeakReference<WebAPI> webAPI;
        WeakReference<WebAPI> webAPI2;
        String action;

        public WeakCleanupRunnable(WebAPI webAPI, String action, WebAPI webAPI2) {
            if (webAPI == webAPI2) {
                throw new RuntimeException("Got same WebAPI twice!");
            }
            this.webAPI = new WeakReference<WebAPI>(webAPI);
            this.action = action;
            this.webAPI2 = new WeakReference<WebAPI>(webAPI2);
        }

        @Override
        public void run() {
            WebAPI webapi = (WebAPI)this.webAPI.get();
            if (webapi != null) {
                webapi.executeScript(this.action);
            }
            Platform.runLater(() -> {
                WebAPI webapi2 = (WebAPI)this.webAPI2.get();
                if (webapi2 != null) {
                    webapi2.closeInstance();
                }
            });
        }
    }

    static class HorizontalStackPane
    extends StackPane {
        HorizontalStackPane() {
        }

        public Orientation getContentBias() {
            return Orientation.HORIZONTAL;
        }

        protected double computeMaxHeight(double v) {
            double v2 = v > 0.0 ? v : this.prefWidth(-1.0);
            return super.computeMaxHeight(v2);
        }

        protected double computePrefHeight(double v) {
            double v2 = v > 0.0 ? v : this.prefWidth(-1.0);
            return super.computePrefHeight(v2);
        }

        protected double computeMaxWidth(double v) {
            double v2 = v > 0.0 ? v : this.prefWidth(-1.0);
            return super.computeMaxWidth(v2);
        }
    }
}

