/*
 * Decompiled with CFR 0.152.
 */
package one.jpro.platform.image.manager.source;

import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import javax.imageio.ImageIO;
import one.jpro.platform.image.manager.ImageUtils;
import one.jpro.platform.image.manager.source.ImageSource;
import one.jpro.platform.image.manager.source.ImageSourceException;
import org.json.JSONObject;

public class ImageSourceFile
implements ImageSource {
    private final File file;

    public ImageSourceFile(File file) {
        this.file = file;
    }

    public ImageSourceFile(String path) {
        this.file = new File(path);
    }

    @Override
    public BufferedImage loadImage() {
        try {
            return ImageIO.read(this.file);
        }
        catch (IOException ex) {
            throw new ImageSourceException("Failed to load image from file: " + this.file.getAbsolutePath(), ex);
        }
    }

    @Override
    public long identityHashValue() {
        try {
            byte[] fileBytes = Files.readAllBytes(this.file.toPath());
            return ImageUtils.computeHashValue(fileBytes);
        }
        catch (IOException ex) {
            throw new ImageSourceException("Failed to compute hash value for the file: " + this.file.getAbsolutePath(), ex);
        }
    }

    @Override
    public String getFileName() {
        return this.file.getName();
    }

    @Override
    public JSONObject toJSON() {
        JSONObject json = new JSONObject();
        json.put("type", (Object)this.getClass().getSimpleName());
        json.put("path", (Object)ImageUtils.escapeJson(this.file.getAbsolutePath()));
        return json;
    }
}

