/*
 * Decompiled with CFR 0.152.
 */
package one.jpro.platform.image.manager.source;

import java.awt.image.BufferedImage;
import java.io.InputStream;
import java.net.URL;
import java.net.URLConnection;
import java.nio.file.Files;
import java.nio.file.Paths;
import javax.imageio.ImageIO;
import one.jpro.platform.image.manager.ImageUtils;
import one.jpro.platform.image.manager.source.ImageSource;
import one.jpro.platform.image.manager.source.ImageSourceException;
import org.json.JSONObject;

public class ImageSourceResource
implements ImageSource {
    private final String resourcePath;

    public ImageSourceResource(String resourcePath) {
        this.resourcePath = resourcePath;
    }

    @Override
    public BufferedImage loadImage() {
        BufferedImage bufferedImage;
        block9: {
            InputStream is = this.getClass().getResourceAsStream(this.resourcePath);
            try {
                if (is == null) {
                    throw new ImageSourceException("Resource not found: " + this.resourcePath);
                }
                bufferedImage = ImageIO.read(is);
                if (is == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (is != null) {
                        try {
                            is.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception e) {
                    throw new ImageSourceException("Error loading resource: " + this.resourcePath, e);
                }
            }
            is.close();
        }
        return bufferedImage;
    }

    @Override
    public long identityHashValue() {
        try {
            URL resourceUrl = this.getClass().getResource(this.resourcePath);
            if (resourceUrl == null) {
                throw new ImageSourceException("Resource not found: " + this.resourcePath);
            }
            URLConnection conn = resourceUrl.openConnection();
            long lastModified = conn.getLastModified();
            if (lastModified == 0L) {
                byte[] resourceData = Files.readAllBytes(Paths.get(resourceUrl.toURI()));
                return ImageUtils.computeHashValue(resourceData);
            }
            return lastModified;
        }
        catch (Exception ex) {
            throw new ImageSourceException("Error obtaining modification date for resource: " + this.resourcePath, ex);
        }
    }

    @Override
    public JSONObject toJSON() {
        JSONObject json = new JSONObject();
        json.put("type", (Object)this.getClass().getSimpleName());
        json.put("resourcePath", (Object)ImageUtils.escapeJson(this.resourcePath));
        return json;
    }

    @Override
    public String getFileName() {
        return this.resourcePath.substring(this.resourcePath.lastIndexOf(47) + 1);
    }
}

