/*
 * Decompiled with CFR 0.152.
 */
package one.jpro.platform.image.manager.transformer;

import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import one.jpro.platform.image.manager.transformer.ImageTransformer;
import one.jpro.platform.image.manager.transformer.ImageTransformerHelpers;
import org.json.JSONObject;

public class ImageTransformerWH
implements ImageTransformer {
    private final int targetWidth;
    private final int targetHeight;

    public ImageTransformerWH(int targetWidth, int targetHeight) {
        this.targetWidth = targetWidth;
        this.targetHeight = targetHeight;
    }

    public ImageTransformerWH(int targetWidth, int targetHeight, double ratio) {
        this.targetWidth = (int)((double)targetWidth * ratio);
        this.targetHeight = (int)((double)targetHeight * ratio);
    }

    @Override
    public BufferedImage transform(BufferedImage original) {
        BufferedImage resizedImage = new BufferedImage(this.targetWidth, this.targetHeight, original.getType());
        Graphics2D g2d = resizedImage.createGraphics();
        ImageTransformerHelpers.graphicsDefaultConfiguration(g2d);
        g2d.drawImage(original, 0, 0, this.targetWidth, this.targetHeight, null);
        g2d.dispose();
        return resizedImage;
    }

    @Override
    public JSONObject toJSON() {
        JSONObject json = new JSONObject();
        json.put("type", (Object)this.getClass().getSimpleName());
        json.put("targetWidth", this.targetWidth);
        json.put("targetHeight", this.targetHeight);
        return json;
    }
}

