/*
 * Decompiled with CFR 0.152.
 */
package one.jpro.platform.image.manager;

import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.concurrent.CompletableFuture;
import javafx.scene.image.Image;
import one.jpro.platform.image.manager.ImageDefinition;
import one.jpro.platform.image.manager.ImageResult;
import one.jpro.platform.image.manager.encoder.ImageEncoder;
import one.jpro.platform.image.manager.source.ImageSource;
import one.jpro.platform.image.manager.transformer.ImageTransformer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ImageManager {
    private static final Logger logger = LoggerFactory.getLogger(ImageManager.class);
    private static final String CACHE_DIR_NAME = "jpro.imagemanager.cache";
    private static final String CACHE_DIR_HOME = System.getProperty("user.home") + "/.jpro/image-manager";
    private static String CACHE_DIR = null;
    private static volatile ImageManager defaultInstance;

    private ImageManager() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static ImageManager getInstance() {
        if (defaultInstance != null) return defaultInstance;
        Class<ImageManager> clazz = ImageManager.class;
        synchronized (ImageManager.class) {
            if (defaultInstance != null) return defaultInstance;
            CACHE_DIR = System.getProperty(CACHE_DIR_NAME) != null ? System.getProperty(CACHE_DIR_NAME) : CACHE_DIR_HOME;
            defaultInstance = new ImageManager();
            // ** MonitorExit[var0] (shouldn't be in output)
            return defaultInstance;
        }
    }

    File getCacheDir() {
        return new File(CACHE_DIR);
    }

    public ImageResult loadImage(ImageDefinition imageDefinition) {
        String origFileName = imageDefinition.getSource().getFileName();
        String baseName = origFileName.substring(0, origFileName.lastIndexOf("."));
        String fileName = baseName + "." + imageDefinition.getEncoder().getFileExtension();
        try {
            String savedDef;
            File keyFile;
            String hash = ImageManager.computeImageDefinitionHash(imageDefinition);
            File hashDir = new File(CACHE_DIR, hash);
            File imageFile = new File(hashDir, fileName);
            if (hashDir.exists() && (keyFile = new File(hashDir, "key")).exists() && imageFile.exists() && (savedDef = Files.readString(keyFile.toPath())).equals(imageDefinition.toJSON().toString())) {
                String wh = Files.readString(new File(hashDir, "wh").toPath());
                String[] dims = wh.split(",");
                return new ImageResult(imageFile, Integer.parseInt(dims[0]), Integer.parseInt(dims[1]));
            }
            BufferedImage img = imageDefinition.getSource().loadImage();
            img = imageDefinition.getTransformer().transform(img);
            imageDefinition.getEncoder().saveImage(img, imageFile);
            ImageResult result = new ImageResult(imageFile, img.getWidth(), img.getHeight());
            Files.writeString(new File(hashDir, "key").toPath(), (CharSequence)imageDefinition.toJSON().toString(), new OpenOption[0]);
            Files.writeString(new File(hashDir, "wh").toPath(), (CharSequence)(img.getWidth() + "," + img.getHeight()), new OpenOption[0]);
            return result;
        }
        catch (IOException ex) {
            logger.error("Error while loading image", (Throwable)ex);
            throw new RuntimeException(ex);
        }
    }

    CompletableFuture<ImageResult> loadImageFuture(ImageDefinition imageDefinition) {
        return CompletableFuture.supplyAsync(() -> this.loadImage(imageDefinition));
    }

    Image loadFXImage(ImageSource source, ImageTransformer transformation, ImageEncoder encoding) {
        ImageDefinition def = new ImageDefinition(source, transformation, encoding);
        ImageResult result = this.loadImage(def);
        return result.toFXImage();
    }

    CompletableFuture<Image> loadFXImageFuture(ImageSource source, ImageTransformer transformer, ImageEncoder encoder) {
        return CompletableFuture.supplyAsync(() -> this.loadFXImage(source, transformer, encoder));
    }

    public static String computeImageDefinitionHash(ImageDefinition imageDefinition) {
        try {
            MessageDigest digest = MessageDigest.getInstance("MD5");
            byte[] hashBytes = digest.digest(imageDefinition.toJSON().toString().getBytes(StandardCharsets.UTF_8));
            StringBuilder hexString = new StringBuilder();
            for (byte b : hashBytes) {
                String hex = Integer.toHexString(0xFF & b);
                if (hex.length() == 1) {
                    hexString.append('0');
                }
                hexString.append(hex);
            }
            return hexString.toString();
        }
        catch (NoSuchAlgorithmException ex) {
            logger.error("Error computing MD5 hash", (Throwable)ex);
            throw new RuntimeException(ex);
        }
    }

    void clearCache() {
        File cacheDirectory = new File(CACHE_DIR);
        this.deleteDirectoryRecursively(cacheDirectory);
    }

    private void deleteDirectoryRecursively(File file) {
        File[] files;
        if (file.isDirectory() && (files = file.listFiles()) != null) {
            for (File child : files) {
                this.deleteDirectoryRecursively(child);
            }
        }
        file.delete();
    }
}

