/*
 * Decompiled with CFR 0.152.
 */
package one.jpro.platform.image.manager.encoder;

import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import javax.imageio.ImageIO;
import one.jpro.platform.image.manager.encoder.ImageEncoder;
import one.jpro.platform.image.manager.encoder.ImageEncoderException;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ImageEncoderJPG
implements ImageEncoder {
    private static final Logger logger = LoggerFactory.getLogger(ImageEncoderJPG.class);
    private final double quality;

    public ImageEncoderJPG() {
        this(0.8);
    }

    public ImageEncoderJPG(double quality) {
        if (quality < 0.0 || quality > 1.0) {
            throw new IllegalArgumentException("Quality should be between 0.0 and 1.0");
        }
        this.quality = quality;
    }

    @Override
    public void saveImage(BufferedImage image, File target) {
        String fileExtensionUpperCase = this.getFileExtension().toUpperCase();
        try {
            boolean result;
            File parentFile = target.getParentFile();
            if (parentFile != null && !parentFile.exists()) {
                if (parentFile.mkdirs()) {
                    logger.info("Created directory: {}", (Object)parentFile.getAbsolutePath());
                } else {
                    throw new ImageEncoderException("Failed to create directory: " + parentFile.getAbsolutePath());
                }
            }
            if (!(result = ImageIO.write((RenderedImage)image, fileExtensionUpperCase, target))) {
                throw new ImageEncoderException("The given " + fileExtensionUpperCase + " format is not supported.");
            }
        }
        catch (IOException ex) {
            throw new ImageEncoderException("Error while saving the image to " + fileExtensionUpperCase + " format.", ex);
        }
    }

    @Override
    public String getFileExtension() {
        return "jpg";
    }

    @Override
    public JSONObject toJSON() {
        JSONObject json = new JSONObject();
        json.put("type", (Object)this.getClass().getSimpleName());
        json.put("quality", this.quality);
        json.put("fileExtension", (Object)this.getFileExtension());
        return json;
    }
}

