/*
 * Decompiled with CFR 0.152.
 */
package one.jpro.platform.image.manager.source;

import java.awt.image.BufferedImage;
import java.io.IOException;
import java.net.URL;
import java.net.URLConnection;
import javax.imageio.ImageIO;
import one.jpro.platform.image.manager.ImageUtils;
import one.jpro.platform.image.manager.source.ImageSource;
import one.jpro.platform.image.manager.source.ImageSourceException;
import org.json.JSONObject;

public class ImageSourceURL
implements ImageSource {
    private final URL url;

    public ImageSourceURL(URL url) {
        this.url = url;
    }

    @Override
    public BufferedImage loadImage() {
        try {
            return ImageIO.read(this.url);
        }
        catch (IOException ex) {
            throw new ImageSourceException("Error while reading image from URL: " + String.valueOf(this.url), ex);
        }
    }

    @Override
    public long identityHashValue() {
        try {
            URLConnection connection = this.url.openConnection();
            long lastModified = connection.getLastModified();
            String combined = this.url.toString() + lastModified;
            return ImageUtils.computeHashValue(combined.getBytes());
        }
        catch (IOException e) {
            throw new ImageSourceException("Error while getting modification date for URL: " + String.valueOf(this.url), e);
        }
    }

    @Override
    public JSONObject toJSON() {
        JSONObject json = new JSONObject();
        json.put("type", (Object)this.getClass().getSimpleName());
        json.put("url", (Object)ImageUtils.escapeJson(this.url.toString()));
        return json;
    }

    @Override
    public String getFileName() {
        return this.url.toString().substring(this.url.toString().lastIndexOf(47) + 1);
    }
}

