/*
 * Decompiled with CFR 0.152.
 */
package one.jpro.platform.image.manager;

import one.jpro.platform.image.manager.ImageManager;
import one.jpro.platform.image.manager.JsonConvertible;
import one.jpro.platform.image.manager.encoder.ImageEncoder;
import one.jpro.platform.image.manager.source.ImageSource;
import one.jpro.platform.image.manager.transformer.ImageTransformer;
import org.json.JSONObject;

public class ImageDefinition
implements JsonConvertible {
    private final ImageSource source;
    private final ImageTransformer transformer;
    private final ImageEncoder encoder;

    public ImageDefinition(ImageSource source, ImageTransformer transformer, ImageEncoder encoder) {
        this.source = source;
        this.transformer = transformer;
        this.encoder = encoder;
    }

    @Override
    public JSONObject toJSON() {
        JSONObject json = new JSONObject();
        json.put("source", (Object)this.source.toJSON());
        json.put("transformer", (Object)this.transformer.toJSON());
        json.put("encoder", (Object)this.encoder.toJSON());
        return json;
    }

    public ImageSource getSource() {
        return this.source;
    }

    public ImageTransformer getTransformer() {
        return this.transformer;
    }

    public ImageEncoder getEncoder() {
        return this.encoder;
    }

    String getHashString() {
        return ImageManager.computeImageDefinitionHash(this);
    }
}

