/*
 * Decompiled with CFR 0.152.
 */
package one.jpro.platform.image.manager.transformer;

import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import one.jpro.platform.image.manager.transformer.ImageTransformer;
import one.jpro.platform.image.manager.transformer.ImageTransformerHelpers;
import org.json.JSONObject;

public class ImageTransformerFitHeight
implements ImageTransformer {
    private final int targetHeight;

    public ImageTransformerFitHeight(int targetHeight) {
        this.targetHeight = targetHeight;
    }

    public ImageTransformerFitHeight(int targetHeight, int devicePixelRatio) {
        this.targetHeight = targetHeight * devicePixelRatio;
    }

    @Override
    public BufferedImage transform(BufferedImage original) {
        double aspectRatio = (double)original.getWidth() / (double)original.getHeight();
        int newWidth = (int)((double)this.targetHeight * aspectRatio);
        BufferedImage resized = new BufferedImage(newWidth, this.targetHeight, original.getType());
        Graphics2D g2d = resized.createGraphics();
        ImageTransformerHelpers.graphicsDefaultConfiguration(g2d);
        g2d.drawImage(original, 0, 0, newWidth, this.targetHeight, null);
        g2d.dispose();
        return resized;
    }

    @Override
    public JSONObject toJSON() {
        JSONObject json = new JSONObject();
        json.put("type", (Object)this.getClass().getSimpleName());
        json.put("targetHeight", this.targetHeight);
        return json;
    }
}

